package com.tcbj.website.dto;


import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/** 标签分页查询DTO */
@ApiModel("标签分页查询DTO")
public class LabelLiteratureQueryDto extends PageModel {


    /** 是否删除 */
    @ApiModelProperty("是否删除 0:否 1：是")
    private Integer isDelete;
    /** 是否英文标签 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文标签 0:否 1：是")
    private Integer isEn;
    /** 名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("名称")
    private String name;
    /** 是否热门 */
    @ApiModelProperty("是否热门 0：否 1：是")
    private Integer isHot;

    //所属一级标签id
    @ApiModelProperty("所属一级标签id")
    private String labelFirstItemId;
    //所属一级标签名称
    @ApiModelProperty("所属一级标签名称")
    private String labelFirstItemName;
    //标签级别
    @ApiModelProperty("标签级别")
    private Integer labelLever;

    @ApiModelProperty("所属类别id")
    private String menuItemId;
    //所属一级标签名称
    @ApiModelProperty("所属类别名称")
    private String menuItemName;

    public String getMenuItemId() {
        return menuItemId;
    }

    public void setMenuItemId(String menuItemId) {
        this.menuItemId = menuItemId;
    }

    public String getMenuItemName() {
        return menuItemName;
    }

    public void setMenuItemName(String menuItemName) {
        this.menuItemName = menuItemName;
    }

    public String getLabelFirstItemId() {
        return labelFirstItemId;
    }

    public void setLabelFirstItemId(String labelFirstItemId) {
        this.labelFirstItemId = labelFirstItemId;
    }

    public String getLabelFirstItemName() {
        return labelFirstItemName;
    }

    public void setLabelFirstItemName(String labelFirstItemName) {
        this.labelFirstItemName = labelFirstItemName;
    }

    public Integer getLabelLever() {
        return labelLever;
    }

    public void setLabelLever(Integer labelLever) {
        this.labelLever = labelLever;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public Integer getIsEn() {
        return isEn;
    }

    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getIsHot() {
        return isHot;
    }

    public void setIsHot(Integer isHot) {
        this.isHot = isHot;
    }
}
