package com.tcbj.website.dto;

import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/** 用户查询DTO */
@ApiModel("用户表查询DTO")
public class MemberUserPageModel extends PageModel {
    /** 是否删除 */
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 手机号码 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("手机号码")
    private Long mobile;
    /** 名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("名称")
    private String name;
    /** 密码 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("密码")
    private String password;
    /** 角色 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("角色：0-默认游客 1-会员 2-内部员工")
    private Integer role;
    /** 性别 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("性别：0-男 1-女")
    private Integer sex;
    /** 单位 查询参数**/
    @ApiModelProperty("单位")
    private String unitName;
    /** esb单位 查询参数**/
    @ApiModelProperty("单位")
    private String esbDepartments;

    public String getEsbDepartments() {
        return esbDepartments;
    }

    public void setEsbDepartments(String esbDepartments) {
        this.esbDepartments = esbDepartments;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public Long getMobile() {
        return mobile;
    }

    public void setMobile(Long mobile) {
        this.mobile = mobile;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getRole() {
        return role;
    }

    public void setRole(Integer role) {
        this.role = role;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
}
