package com.tcbj.website.dto;

import io.swagger.annotations.ApiModel;
import javax.validation.constraints.NotNull;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

/** 研究员新增修改DTO */
@ApiModel("研究员新增修改DTO")
public class ResearcherSaveDto {

    /** 身份 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("身份")
    private String identity;
    /** 介绍 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("介绍")
    private String introduce;
    /** 姓名 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("姓名")
    private String name;
    /** 头像 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("头像")
    private String photo;
    /** 职务 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("职务")
    private List<String> position;
    /** 研究团队 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("研究团队")
    private String researcherGroupId;
    /** 排序 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("排序")
    private Integer sort;
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("状态：0-草稿 1-未发布 2-预约发布 3-已发布  4-取消发布")
    private Integer status;

    /** 是否英文 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文")
    private Integer isEn;

    @ApiModelProperty("是否移动端显示")
    private Integer isPhone;


    @ApiModelProperty("是否移动端")
    private Integer type;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("详情")
    private String content;

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
    /**
     * 设置 {@link #identity}
     *
     * @param identity {@link #identity}
     */
    public void setIdentity(String identity) {
        this.identity = identity;
    }
    /**
     * 获取 {@link #identity}
     *
     * @return {@link #identity}
     */
    public String getIdentity() {
        return identity;
    }
    /**
     * 设置 {@link #introduce}
     *
     * @param introduce {@link #introduce}
     */
    public void setIntroduce(String introduce) {
        this.introduce = introduce;
    }
    /**
     * 获取 {@link #introduce}
     *
     * @return {@link #introduce}
     */
    public String getIntroduce() {
        return introduce;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
    /**
     * 设置 {@link #photo}
     *
     * @param photo {@link #photo}
     */
    public void setPhoto(String photo) {
        this.photo = photo;
    }
    /**
     * 获取 {@link #photo}
     *
     * @return {@link #photo}
     */
    public String getPhoto() {
        return photo;
    }
    /**
     * 设置 {@link #position}
     *
     * @param position {@link #position}
     */
    public void setPosition(List<String> position) {
        this.position = position;
    }
    /**
     * 获取 {@link #position}
     *
     * @return {@link #position}
     */
    public List<String> getPosition() {
        return position;
    }
    /**
     * 设置 {@link #researcherGroupId}
     *
     * @param researcherGroupId {@link #researcherGroupId}
     */
    public void setResearcherGroupId(String researcherGroupId) {
        this.researcherGroupId = researcherGroupId;
    }
    /**
     * 获取 {@link #researcherGroupId}
     *
     * @return {@link #researcherGroupId}
     */
    public String getResearcherGroupId() {
        return researcherGroupId;
    }
    /**
     * 设置 {@link #sort}
     *
     * @param sort {@link #sort}
     */
    public void setSort(Integer sort) {
        this.sort = sort;
    }
    /**
     * 获取 {@link #sort}
     *
     * @return {@link #sort}
     */
    public Integer getSort() {
        return sort;
    }

    public Integer getIsEn() {
        return isEn;
    }

    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }

    public Integer getIsPhone() {
        return isPhone;
    }

    public void setIsPhone(Integer isPhone) {
        this.isPhone = isPhone;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
