package com.tcbj.website.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import javax.validation.constraints.NotNull;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.List;

/** 在研项目树维护表新增修改DTO */
@ApiModel("在研项目树维护表新增修改DTO")
public class UnderstudiedItemTreeSaveDto {

    /** 是否删除 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文")
    private Integer isEn;
    /** 状态：草稿：0 启用 ：1 禁用 ：2 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("状态：草稿：0 启用 ：1 禁用 ：2")
    private Integer status;
    /** 图片链接 */
    @ApiModelProperty("图片链接数组")
    private String url;

    /** 发布时间 */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("发布时间")
    private Date releaseTime;
    /** 版本号 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("版本号")
    private String version;

    /** 栏目id */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("栏目id")
    private String menuItemId;
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("PC/移动")
    private Integer isPhone;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文章ID")
    private Integer articleContentId;
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文章栏目ID")
    private Integer articleContentMenuItemId;

    public Integer getArticleContentMenuItemId() {
        return articleContentMenuItemId;
    }

    public void setArticleContentMenuItemId(Integer articleContentMenuItemId) {
        this.articleContentMenuItemId = articleContentMenuItemId;
    }

    public Integer getArticleContentId() {
        return articleContentId;
    }

    public void setArticleContentId(Integer articleContentId) {
        this.articleContentId = articleContentId;
    }


    public Integer getIsPhone() {
        return isPhone;
    }

    public void setIsPhone(Integer isPhone) {
        this.isPhone = isPhone;
    }


    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #isEn}
     *
     * @param isEn {@link #isEn}
     */
    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }
    /**
     * 获取 {@link #isEn}
     *
     * @return {@link #isEn}
     */
    public Integer getIsEn() {
        return isEn;
    }
    /**
     * 设置 {@link #status}
     *
     * @param status {@link #status}
     */
    public void setStatus(Integer status) {
        this.status = status;
    }
    /**
     * 获取 {@link #status}
     *
     * @return {@link #status}
     */
    public Integer getStatus() {
        return status;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getReleaseTime() {
        return releaseTime;
    }

    public void setReleaseTime(Date releaseTime) {
        this.releaseTime = releaseTime;
    }

    /**
     * 设置 {@link #version}
     *
     * @param version {@link #version}
     */
    public void setVersion(String version) {
        this.version = version;
    }
    /**
     * 获取 {@link #version}
     *
     * @return {@link #version}
     */
    public String getVersion() {
        return version;
    }

    public String getMenuItemId() {
        return menuItemId;
    }

    public void setMenuItemId(String menuItemId) {
        this.menuItemId = menuItemId;
    }
}
