package com.tcbj.website.dto;


import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/** 首页搜索DTO */
@ApiModel("首页搜索DTO")
public class WebsiteSearchDto {

    /** 名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("名称")
    private String name;

    /** 是否英文 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文")
    private Integer isEn;

    /** 文章标签集合 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文章标签ID集合")
    private List<String> articleLabelIds;

    /** 热搜词集合 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("热搜词名称集合")
    private List<String> popularWords;


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getIsEn() {
        return isEn;
    }

    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }

    public List<String> getArticleLabelIds() {
        return articleLabelIds;
    }

    public void setArticleLabelIds(List<String> articleLabelIds) {
        this.articleLabelIds = articleLabelIds;
    }

    public List<String> getPopularWords() {
        return popularWords;
    }

    public void setPopularWords(List<String> popularWords) {
        this.popularWords = popularWords;
    }
}
