package com.tcbj.website.dto;


import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;


@ApiModel("知识库搜索DTO")
public class WebsiteSearchForKnowledgeDto {

    /** 名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("名称")
    private String name;

    /** 是否英文 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文")
    private Integer isEn;

    /** 文章标签集合 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("知识库标签标签ID集合")
    private List<String> knowledgeIdList;

    /** 文章标签集合 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("产品标签ID集合")
    private List<String> productIdList;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("营养成分标签ID集合")
    private List<String> nutritionalIdList;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("功能标签ID集合")
    private List<String> functionIdList;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("指南共识标签ID集合")
    private List<String> companionIdList;


    /** 热搜词集合 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文字搜索集合")
    private List<String> searchWords;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("上架时间")
    private Date shelfTime;

    public Date getShelfTime() {
        return shelfTime;
    }

    public void setShelfTime(Date shelfTime) {
        this.shelfTime = shelfTime;
    }

    public List<String> getCompanionIdList() {
        return companionIdList;
    }

    public void setCompanionIdList(List<String> companionIdList) {
        this.companionIdList = companionIdList;
    }

    public List<String> getProductIdList() {
        return productIdList;
    }

    public void setProductIdList(List<String> productIdList) {
        this.productIdList = productIdList;
    }

    public List<String> getNutritionalIdList() {
        return nutritionalIdList;
    }

    public void setNutritionalIdList(List<String> nutritionalIdList) {
        this.nutritionalIdList = nutritionalIdList;
    }

    public List<String> getFunctionIdList() {
        return functionIdList;
    }

    public void setFunctionIdList(List<String> functionIdList) {
        this.functionIdList = functionIdList;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getIsEn() {
        return isEn;
    }

    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }

    public List<String> getKnowledgeIdList() {
        return knowledgeIdList;
    }

    public void setKnowledgeIdList(List<String> knowledgeIdList) {
        this.knowledgeIdList = knowledgeIdList;
    }

    public List<String> getSearchWords() {
        return searchWords;
    }

    public void setSearchWords(List<String> searchWords) {
        this.searchWords = searchWords;
    }
}
