package com.tcbj.website.dto;

import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;



@ApiModel("知识库分类分页搜索DTO")
public class WebsiteSearchPageForKnowledgeDto extends PageModel {

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("名称")
    private String name;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文")
    private Integer isEn;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("知识库标签标签ID集合")
    private List<String> knowledgeIdList;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("产品标签ID集合")
    private List<String> productIdList;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("营养成分标签ID集合")
    private List<String> nutritionalIdList;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("功能标签ID集合")
    private List<String> functionIdList;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文字搜索集合")
    private List<String> searchWords;

    /** 二级栏目名称 */
    @ApiModelProperty("二级栏目id")
    private String menuSecondItemId;
    /** 二级栏目名称 */
    @ApiModelProperty("二级栏目名称")
    private String menuSecondItemName;

    @ApiModelProperty("所属三级级栏目id")
    private String  menuThreeItemId;

    @ApiModelProperty("所属三级级栏目名称")
    private String  menuThreeItemName;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("所属栏目id")
    private String menuItemId;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("所属栏目名称")
    private String menuItemName;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("上架时间")
    private Date shelfTime;

    public Date getShelfTime() {
        return shelfTime;
    }

    public void setShelfTime(Date shelfTime) {
        this.shelfTime = shelfTime;
    }

    public String getMenuSecondItemId() {
        return menuSecondItemId;
    }

    public void setMenuSecondItemId(String menuSecondItemId) {
        this.menuSecondItemId = menuSecondItemId;
    }

    public String getMenuSecondItemName() {
        return menuSecondItemName;
    }

    public void setMenuSecondItemName(String menuSecondItemName) {
        this.menuSecondItemName = menuSecondItemName;
    }

    public String getMenuThreeItemId() {
        return menuThreeItemId;
    }

    public void setMenuThreeItemId(String menuThreeItemId) {
        this.menuThreeItemId = menuThreeItemId;
    }

    public String getMenuThreeItemName() {
        return menuThreeItemName;
    }

    public void setMenuThreeItemName(String menuThreeItemName) {
        this.menuThreeItemName = menuThreeItemName;
    }

    public String getMenuItemId() {
        return menuItemId;
    }

    public void setMenuItemId(String menuItemId) {
        this.menuItemId = menuItemId;
    }

    public String getMenuItemName() {
        return menuItemName;
    }

    public void setMenuItemName(String menuItemName) {
        this.menuItemName = menuItemName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getIsEn() {
        return isEn;
    }

    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }

    public List<String> getKnowledgeIdList() {
        return knowledgeIdList;
    }

    public void setKnowledgeIdList(List<String> knowledgeIdList) {
        this.knowledgeIdList = knowledgeIdList;
    }

    public List<String> getProductIdList() {
        return productIdList;
    }

    public void setProductIdList(List<String> productIdList) {
        this.productIdList = productIdList;
    }

    public List<String> getNutritionalIdList() {
        return nutritionalIdList;
    }

    public void setNutritionalIdList(List<String> nutritionalIdList) {
        this.nutritionalIdList = nutritionalIdList;
    }

    public List<String> getFunctionIdList() {
        return functionIdList;
    }

    public void setFunctionIdList(List<String> functionIdList) {
        this.functionIdList = functionIdList;
    }

    public List<String> getSearchWords() {
        return searchWords;
    }

    public void setSearchWords(List<String> searchWords) {
        this.searchWords = searchWords;
    }
}
