package com.tcbj.website.enums;

/**枚举**/
public enum FundStatusEnum {

    TO_AUDIT(0,"待审核"),
    OVER_AUDIT(1,"审核通过"),
    NO_AUDIT(2,"审核不通过");

    private Integer code;
    private String msg;

    FundStatusEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }
    public static FundStatusEnum getEnum(Integer code){
        FundStatusEnum result = null;
        for(FundStatusEnum oemEnum : values()){
            if(code.equals(oemEnum.getCode())){
                result = oemEnum;
                break;
            }
        }
        return result;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
