package com.tcbj.website.enums;

/**枚举**/
public enum SystemRoleEnum {

    VISITORS(0,"默认游客"),
    MEMBER(1,"会员"),
    INTERNAL(2,"内部员工");

    private Integer code;
    private String msg;

    SystemRoleEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }
    public static SystemRoleEnum getEnum(Integer code){
        SystemRoleEnum result = null;
        for(SystemRoleEnum oemEnum : values()){
            if(code.equals(oemEnum.getCode())){
                result = oemEnum;
                break;
            }
        }
        return result;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
