package com.tcbj.website.model;

import javax.persistence.Table;

import com.cyberway.msf.commons.model.handler.IntegerListTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import tk.mybatis.mapper.annotation.NameStyle;
import tk.mybatis.mapper.code.Style;
import io.swagger.annotations.ApiModel;
import com.cyberway.msf.commons.model.base.BusinessEntityWithOrganization;
import java.util.List;
import tk.mybatis.mapper.annotation.ColumnType;
import com.cyberway.msf.commons.model.handler.StringListTypeHandler;
import org.apache.ibatis.type.JdbcType;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import javax.persistence.Column;
import java.util.Date;

/** 文章内容 */
@Table(name = "website_article_content")
@NameStyle(Style.normal)
@ApiModel("文章内容")
public class ArticleContent extends BusinessEntityWithOrganization {

    /** 附件 */
    @ColumnType(typeHandler = StringListTypeHandler.class, jdbcType = JdbcType.VARCHAR)
    @ApiModelProperty("附件")
    private List<String> accessory;
    /** 文章类别 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @Column(name = "article_category")
    @ApiModelProperty("文章类别")
    private String articleCategoryId;
    /** 文章标签 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @Column(name = "article_label")
    @ApiModelProperty("文章标签")
    private String articleLabelId;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文章类别一级标题(知识库专用字段)")
    @Column(name = "article_category_first_name")
    private String articleCategoryFirstName;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文章类别二级标题(知识库专用字段)")
    @Column(name = "article_category_second_name")
    private String articleCategorySecondName;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("出版社名称(知识库专用字段)")
    private String pressName;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("参考文献(知识库专用字段)")
    private String reference;

    /** 内容 */
    @ApiModelProperty("内容")
    private String content;
    /** 封面图片 */
    @Column(name = "cover_picture")
    @ApiModelProperty("封面图片")
    private String coverPicture;
    /** 简介 */
    @ApiModelProperty("简介")
    private String description;
    /** 阅读量 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("阅读量")
    private Integer hits;
    /** 是否删除 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @Column(name = "is_delete")
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @Column(name = "is_en")
    @ApiModelProperty("是否英文")
    private Integer isEn;
    /** 是否置顶 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @Column(name = "is_stick")
    @ApiModelProperty("是否置顶")
    private Integer isStick;
    /** 所属栏目 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @Column(name = "menu_item_id")
    @ApiModelProperty("所属栏目")
    private String menuItemId;
    /** 标题 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("标题")
    private String name;
    /** 合作机构 */
    @ApiModelProperty("合作机构")
    private String operating;
    /** pdf文件 */
    @ApiModelProperty("pdf文件")
    private String pdf;
    /** 项目负责人 */
    @Column(name = "project_leader")
    @ApiModelProperty("项目负责人")
    private String projectLeader;
    /** 发布时间 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("发行时间")
    private Date releaseTime;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("上架时间")
    private Date shelfTime;
    /** 所属权限 */
    @ColumnType(typeHandler = IntegerListTypeHandler.class, jdbcType = JdbcType.VARCHAR)
    @ApiModelProperty("所属权限")
    private List<Integer> role;
    /** 状态 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("状态：0-草稿 1-未发布 2-预约发布 3-已发布  4-取消发布")
    private Integer status;
    /** 标题图片 */
    @Column(name = "title_picture")
    @ApiModelProperty("标题图片")
    private String titlePicture;
    /** 视频 */
    @ApiModelProperty("视频")
    private String video;
    /** 地点 */
    @ApiModelProperty("地点")
    private String  site;
    /** 视频分组ID */
    @ApiModelProperty("视频分组ID")
    private String videoGroupId;
    /** 一级栏目名称 */
    @ApiModelProperty("一级栏目名称")
    private String menuFirstItemId;
    /** 二级栏目名称 */
    @ApiModelProperty("二级栏目名称")
    private String menuSecondItemId;

    @ApiModelProperty("所属三级级栏目id")
    private String  menuThreeItemId;

    @ApiModelProperty("跳转连接")
    private String url;

    @ApiModelProperty("是否移动端显示")
    private Integer isPhone;

    @ApiModelProperty("二维码地址")
    private String qrCode;

    @ApiModelProperty("视频banner图")
    private String bannerUrl;

    @ApiModelProperty("视频：是否展示首页")
    private Integer isHome;

    @ApiModelProperty("产品排序")
    private Integer productSort;

    @ApiModelProperty("营养成分排序")
    private Integer nutrientSort;

    @ApiModelProperty("功能排序")
    private Integer functionSort;

    public Integer getProductSort() {
        return productSort;
    }

    public void setProductSort(Integer productSort) {
        this.productSort = productSort;
    }

    public Integer getNutrientSort() {
        return nutrientSort;
    }

    public void setNutrientSort(Integer nutrientSort) {
        this.nutrientSort = nutrientSort;
    }

    public Integer getFunctionSort() {
        return functionSort;
    }

    public void setFunctionSort(Integer functionSort) {
        this.functionSort = functionSort;
    }

    public String getReference() {
        return reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getPressName() {
        return pressName;
    }

    public void setPressName(String pressName) {
        this.pressName = pressName;
    }

    public String getArticleCategoryFirstName() {
        return articleCategoryFirstName;
    }

    public void setArticleCategoryFirstName(String articleCategoryFirstName) {
        this.articleCategoryFirstName = articleCategoryFirstName;
    }

    public String getArticleCategorySecondName() {
        return articleCategorySecondName;
    }

    public void setArticleCategorySecondName(String articleCategorySecondName) {
        this.articleCategorySecondName = articleCategorySecondName;
    }

    public Integer getIsHome() {
        return isHome;
    }

    public void setIsHome(Integer isHome) {
        this.isHome = isHome;
    }

    public String getBannerUrl() {
        return bannerUrl;
    }

    public void setBannerUrl(String bannerUrl) {
        this.bannerUrl = bannerUrl;
    }

    public String getQrCode() {
        return qrCode;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    /**
     * 设置 {@link #accessory}
     *
     * @param accessory {@link #accessory}
     */
    public void setAccessory(List<String> accessory) {
        this.accessory = accessory;
    }
    /**
     * 获取 {@link #accessory}
     *
     * @return {@link #accessory}
     */
    public List<String> getAccessory() {
        return accessory;
    }
    /**
     * 设置 {@link #articleCategoryId}
     *
     * @param articleCategoryId {@link #articleCategoryId}
     */
    public void setArticleCategoryId(String articleCategoryId) {
        this.articleCategoryId = articleCategoryId;
    }
    /**
     * 获取 {@link #articleCategoryId}
     *
     * @return {@link #articleCategoryId}
     */
    public String getArticleCategoryId() {
        return articleCategoryId;
    }
    /**
     * 设置 {@link #articleLabelId}
     *
     * @param articleLabelId {@link #articleLabelId}
     */
    public void setArticleLabelId(String articleLabelId) {
        this.articleLabelId = articleLabelId;
    }
    /**
     * 获取 {@link #articleLabelId}
     *
     * @return {@link #articleLabelId}
     */
    public String getArticleLabelId() {
        return articleLabelId;
    }
    /**
     * 设置 {@link #content}
     *
     * @param content {@link #content}
     */
    public void setContent(String content) {
        this.content = content;
    }
    /**
     * 获取 {@link #content}
     *
     * @return {@link #content}
     */
    public String getContent() {
        return content;
    }
    /**
     * 设置 {@link #coverPicture}
     *
     * @param coverPicture {@link #coverPicture}
     */
    public void setCoverPicture(String coverPicture) {
        this.coverPicture = coverPicture;
    }
    /**
     * 获取 {@link #coverPicture}
     *
     * @return {@link #coverPicture}
     */
    public String getCoverPicture() {
        return coverPicture;
    }
    /**
     * 设置 {@link #description}
     *
     * @param description {@link #description}
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 获取 {@link #description}
     *
     * @return {@link #description}
     */
    public String getDescription() {
        return description;
    }
    /**
     * 设置 {@link #hits}
     *
     * @param hits {@link #hits}
     */
    public void setHits(Integer hits) {
        this.hits = hits;
    }
    /**
     * 获取 {@link #hits}
     *
     * @return {@link #hits}
     */
    public Integer getHits() {
        return hits;
    }
    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #isEn}
     *
     * @param isEn {@link #isEn}
     */
    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }
    /**
     * 获取 {@link #isEn}
     *
     * @return {@link #isEn}
     */
    public Integer getIsEn() {
        return isEn;
    }
    /**
     * 设置 {@link #isStick}
     *
     * @param isStick {@link #isStick}
     */
    public void setIsStick(Integer isStick) {
        this.isStick = isStick;
    }
    /**
     * 获取 {@link #isStick}
     *
     * @return {@link #isStick}
     */
    public Integer getIsStick() {
        return isStick;
    }
    /**
     * 设置 {@link #menuItemId}
     *
     * @param menuItemId {@link #menuItemId}
     */
    public void setMenuItemId(String menuItemId) {
        this.menuItemId = menuItemId;
    }
    /**
     * 获取 {@link #menuItemId}
     *
     * @return {@link #menuItemId}
     */
    public String getMenuItemId() {
        return menuItemId;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
    /**
     * 设置 {@link #operating}
     *
     * @param operating {@link #operating}
     */
    public void setOperating(String operating) {
        this.operating = operating;
    }
    /**
     * 获取 {@link #operating}
     *
     * @return {@link #operating}
     */
    public String getOperating() {
        return operating;
    }
    /**
     * 设置 {@link #pdf}
     *
     * @param pdf {@link #pdf}
     */
    public void setPdf(String pdf) {
        this.pdf = pdf;
    }
    /**
     * 获取 {@link #pdf}
     *
     * @return {@link #pdf}
     */
    public String getPdf() {
        return pdf;
    }
    /**
     * 设置 {@link #projectLeader}
     *
     * @param projectLeader {@link #projectLeader}
     */
    public void setProjectLeader(String projectLeader) {
        this.projectLeader = projectLeader;
    }
    /**
     * 获取 {@link #projectLeader}
     *
     * @return {@link #projectLeader}
     */
    public String getProjectLeader() {
        return projectLeader;
    }
    /**
     * 设置 {@link #releaseTime}
     *
     * @param releaseTime {@link #releaseTime}
     */
    public void setReleaseTime(Date releaseTime) {
        this.releaseTime = releaseTime;
    }
    /**
     * 获取 {@link #releaseTime}
     *
     * @return {@link #releaseTime}
     */
    public Date getReleaseTime() {
        return releaseTime;
    }

    public Date getShelfTime() {
        return shelfTime;
    }

    public void setShelfTime(Date shelfTime) {
        this.shelfTime = shelfTime;
    }

    public List<Integer> getRole() {
        return role;
    }

    public void setRole(List<Integer> role) {
        this.role = role;
    }

    /**
     * 设置 {@link #status}
     *
     * @param status {@link #status}
     */
    public void setStatus(Integer status) {
        this.status = status;
    }
    /**
     * 获取 {@link #status}
     *
     * @return {@link #status}
     */
    public Integer getStatus() {
        return status;
    }
    /**
     * 设置 {@link #titlePicture}
     *
     * @param titlePicture {@link #titlePicture}
     */
    public void setTitlePicture(String titlePicture) {
        this.titlePicture = titlePicture;
    }
    /**
     * 获取 {@link #titlePicture}
     *
     * @return {@link #titlePicture}
     */
    public String getTitlePicture() {
        return titlePicture;
    }
    /**
     * 设置 {@link #video}
     *
     * @param video {@link #video}
     */
    public void setVideo(String video) {
        this.video = video;
    }
    /**
     * 获取 {@link #video}
     *
     * @return {@link #video}
     */
    public String getVideo() {
        return video;
    }
    /**
     * 设置 {@link #site}
     *
     * @param site {@link #site}
     */
    public void setSite(String site) {
        this.site = site;
    }
    /**
     * 获取 {@link #site}
     *
     * @return {@link #site}
     */
    public String getSite() {
        return site;
    }

    public String getVideoGroupId() {
        return videoGroupId;
    }

    public void setVideoGroupId(String videoGroupId) {
        this.videoGroupId = videoGroupId;
    }

    public String getMenuFirstItemId() {
        return menuFirstItemId;
    }

    public void setMenuFirstItemId(String menuFirstItemId) {
        this.menuFirstItemId = menuFirstItemId;
    }

    public String getMenuSecondItemId() {
        return menuSecondItemId;
    }

    public void setMenuSecondItemId(String menuSecondItemId) {
        this.menuSecondItemId = menuSecondItemId;
    }

    public String getMenuThreeItemId() {
        return menuThreeItemId;
    }

    public void setMenuThreeItemId(String menuThreeItemId) {
        this.menuThreeItemId = menuThreeItemId;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getIsPhone() {
        return isPhone;
    }

    public void setIsPhone(Integer isPhone) {
        this.isPhone = isPhone;
    }
}
