package com.tcbj.website.model;

import javax.persistence.Table;
import tk.mybatis.mapper.annotation.NameStyle;
import tk.mybatis.mapper.code.Style;
import io.swagger.annotations.ApiModel;
import com.cyberway.msf.commons.model.base.BusinessEntityWithOrganization;
import javax.validation.constraints.NotNull;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;

/** 上传附件表 */
@Table(name = "website_attachment")
@NameStyle(Style.normal)
@ApiModel("上传附件表")
public class Attachment extends BusinessEntityWithOrganization {

    /** 所属实体类 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("所属实体类")
    private String classify;
    /** 所属实体id */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @Column(name = "classify_id")
    @ApiModelProperty("所属实体id")
    private String classifyId;
    /** 附件名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("附件名称")
    private String originalFileName;
    /** 文件链接 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文件链接")
    private String accessUrl;

    /**
     * 设置 {@link #classify}
     *
     * @param classify {@link #classify}
     */
    public void setClassify(String classify) {
        this.classify = classify;
    }
    /**
     * 获取 {@link #classify}
     *
     * @return {@link #classify}
     */
    public String getClassify() {
        return classify;
    }
    /**
     * 设置 {@link #classifyId}
     *
     * @param classifyId {@link #classifyId}
     */
    public void setClassifyId(String classifyId) {
        this.classifyId = classifyId;
    }
    /**
     * 获取 {@link #classifyId}
     *
     * @return {@link #classifyId}
     */
    public String getClassifyId() {
        return classifyId;
    }

    public String getOriginalFileName() {
        return originalFileName;
    }

    public void setOriginalFileName(String originalFileName) {
        this.originalFileName = originalFileName;
    }

    public String getAccessUrl() {
        return accessUrl;
    }

    public void setAccessUrl(String accessUrl) {
        this.accessUrl = accessUrl;
    }
}
