package com.tcbj.website.model;

import com.cyberway.msf.commons.model.base.BusinessEntityWithOrganization;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import tk.mybatis.mapper.annotation.NameStyle;
import tk.mybatis.mapper.code.Style;

import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

/** 知识库标签 */
@Table(name = "website_label_knowledge")
@NameStyle(Style.normal)
@ApiModel("知识库标签")
public class LabelKnowledge extends BusinessEntityWithOrganization {

    /** 描述 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("描述")
    private String description;
    /** 是否删除 */
    @Column(name = "is_delete")
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文标签 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @Column(name = "is_en")
    @ApiModelProperty("是否英文标签")
    private Integer isEn;
    /** 名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("名称")
    private String name;

    /** 是否热门 */
    /** 名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @Column(name = "is_hot")
    @ApiModelProperty("是否热门 0：否 1：是")
    private Integer isHot;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("排序")
    private Integer sort;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("知识库标签标识:1:知识库额外标签,2:知识库文献标签,3:推荐书籍类别")
    private Integer knowledgeTag;

    public Integer getKnowledgeTag() {
        return knowledgeTag;
    }

    public void setKnowledgeTag(Integer knowledgeTag) {
        this.knowledgeTag = knowledgeTag;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    /**
     * 设置 {@link #description}
     *
     * @param description {@link #description}
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 获取 {@link #description}
     *
     * @return {@link #description}
     */
    public String getDescription() {
        return description;
    }
    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #isEn}
     *
     * @param isEn {@link #isEn}
     */
    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }
    /**
     * 获取 {@link #isEn}
     *
     * @return {@link #isEn}
     */
    public Integer getIsEn() {
        return isEn;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }

    public Integer getIsHot() {
        return isHot;
    }

    public void setIsHot(Integer isHot) {
        this.isHot = isHot;
    }
}
