package com.tcbj.website.model;

import javax.persistence.Table;
import tk.mybatis.mapper.annotation.NameStyle;
import tk.mybatis.mapper.code.Style;
import io.swagger.annotations.ApiModel;
import com.cyberway.msf.commons.model.base.BusinessEntityWithOrganization;
import javax.validation.constraints.NotNull;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModelProperty;

/** 研究团队 */
@Table(name = "website_researcher_group")
@NameStyle(Style.normal)
@ApiModel("研究团队")
public class ResearcherGroup extends BusinessEntityWithOrganization {

    /** 描述 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("描述")
    private String description;
    /** 名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("名称")
    private String name;
    /** 排序 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("排序")
    private Integer sort;
    /** 是否首页展示 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否首页展示")
    private Integer isHome;

    public Integer getIsHome() {
        return isHome;
    }

    public void setIsHome(Integer isHome) {
        this.isHome = isHome;
    }

    /**
     * 设置 {@link #description}
     *
     * @param description {@link #description}
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 获取 {@link #description}
     *
     * @return {@link #description}
     */
    public String getDescription() {
        return description;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
    /**
     * 设置 {@link #sort}
     *
     * @param sort {@link #sort}
     */
    public void setSort(Integer sort) {
        this.sort = sort;
    }
    /**
     * 获取 {@link #sort}
     *
     * @return {@link #sort}
     */
    public Integer getSort() {
        return sort;
    }
}
