package com.tcbj.website.vo;

import com.cyberway.msf.commons.model.base.vo.BaseSimpleVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;

/** 文章与标签关联表简单字段VO */
@ApiModel("文章与标签关联表简单字段VO")
public class ArticleContentLabelSimpleForKnowledgeVo extends BaseSimpleVo {

    /** 文章ID */
    @ApiModelProperty("文章ID")
    private String articleContentId;
    /** 标签Id */
    @ApiModelProperty("标签Id")
    private String labelId;

    /** 名称 */
    @ApiModelProperty("标签名称")
    private String name;

    @ApiModelProperty("知识库标签标识:1:知识库额外标签,2:知识库文献标签")
    @Column(name = "knowledge_tag")
    private Integer knowledgeTag;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getKnowledgeTag() {
        return knowledgeTag;
    }

    public void setKnowledgeTag(Integer knowledgeTag) {
        this.knowledgeTag = knowledgeTag;
    }

    /**
     * 设置 {@link #articleContentId}
     *
     * @param articleContentId {@link #articleContentId}
     */
    public void setArticleContentId(String articleContentId) {
        this.articleContentId = articleContentId;
    }
    /**
     * 获取 {@link #articleContentId}
     *
     * @return {@link #articleContentId}
     */
    public String getArticleContentId() {
        return articleContentId;
    }
    /**
     * 设置 {@link #labelId}
     *
     * @param labelId {@link #labelId}
     */
    public void setLabelId(String labelId) {
        this.labelId = labelId;
    }
    /**
     * 获取 {@link #labelId}
     *
     * @return {@link #labelId}
     */
    public String getLabelId() {
        return labelId;
    }
}
