package com.tcbj.website.vo;

import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tcbj.website.dto.AttachmentSaveDto;
import io.swagger.annotations.ApiModel;
import com.cyberway.msf.commons.model.base.vo.BaseSimpleVo;

import java.util.Date;
import java.util.List;
import io.swagger.annotations.ApiModelProperty;
import com.tcbj.website.vo.FundTemplateMinVo;

import javax.validation.constraints.NotNull;

/** 基金申请单简单字段VO */
@ApiModel("基金申请单简单字段VO")
public class FundApplicationFormSimpleVo extends BaseSimpleVo {

    /** 附件链接数组 */
    @ApiModelProperty("附件链接数组")
    private List<AttachmentSaveDto> accessory;
    /** 申请单流水号 */
    @ApiModelProperty("申请单流水号")
    private String code;
    /** 邮箱地址 */
    @ApiModelProperty("邮箱地址")
    private String email;
    /** 模板项目名称 */
    @ApiModelProperty("模板项目名称")
    private FundTemplateMinVo fundTemplate;
    /** 是否删除 */
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文 */
    @ApiModelProperty("是否英文")
    private Integer isEn;
    /** 申请单内容 */
    @ApiModelProperty("申请单内容")
    private String jsonStr;
    /** 手机 */
    @ApiModelProperty("手机")
    private Long mobile;

    /** 申请人id */
    @ApiModelProperty("申请人id")
    private String proposerId;
    /** 姓名 */
    @ApiModelProperty("姓名")
    private String name;
    /** 审核意见 */
    @ApiModelProperty("审核意见 ")
    private String opinion;
    /** 审核状态 */
    @ApiModelProperty("审核状态 0:待审核 1：审核通过 2：审核不通过")
    private Integer status;
    /** 所属单位 */
    @ApiModelProperty("所属单位")
    private String unit;

    /** 申请项目名称 */
    @ApiModelProperty("申请项目名称")
    private String projectName;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createdDate;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date lastModified;

    @Override
    public Date getLastModified() {
        return lastModified;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }


    /**
     * 设置 {@link #accessory}
     *
     * @param accessory {@link #accessory}
     */
    public void setAccessory(List<AttachmentSaveDto> accessory) {
        this.accessory = accessory;
    }
    /**
     * 获取 {@link #accessory}
     *
     * @return {@link #accessory}
     */
    public List<AttachmentSaveDto> getAccessory() {
        return accessory;
    }
    /**
     * 设置 {@link #code}
     *
     * @param code {@link #code}
     */
    public void setCode(String code) {
        this.code = code;
    }
    /**
     * 获取 {@link #code}
     *
     * @return {@link #code}
     */
    public String getCode() {
        return code;
    }
    /**
     * 设置 {@link #email}
     *
     * @param email {@link #email}
     */
    public void setEmail(String email) {
        this.email = email;
    }
    /**
     * 获取 {@link #email}
     *
     * @return {@link #email}
     */
    public String getEmail() {
        return email;
    }
    /**
     * 设置 {@link #fundTemplate}
     *
     * @param fundTemplate {@link #fundTemplate}
     */
    public void setFundTemplate(FundTemplateMinVo fundTemplate) {
        this.fundTemplate = fundTemplate;
    }
    /**
     * 获取 {@link #fundTemplate}
     *
     * @return {@link #fundTemplate}
     */
    public FundTemplateMinVo getFundTemplate() {
        return fundTemplate;
    }
    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #isEn}
     *
     * @param isEn {@link #isEn}
     */
    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }
    /**
     * 获取 {@link #isEn}
     *
     * @return {@link #isEn}
     */
    public Integer getIsEn() {
        return isEn;
    }
    /**
     * 设置 {@link #jsonStr}
     *
     * @param jsonStr {@link #jsonStr}
     */
    public void setJsonStr(String jsonStr) {
        this.jsonStr = jsonStr;
    }
    /**
     * 获取 {@link #jsonStr}
     *
     * @return {@link #jsonStr}
     */
    public String getJsonStr() {
        return jsonStr;
    }
    /**
     * 设置 {@link #mobile}
     *
     * @param mobile {@link #mobile}
     */
    public void setMobile(Long mobile) {
        this.mobile = mobile;
    }
    /**
     * 获取 {@link #mobile}
     *
     * @return {@link #mobile}
     */
    public Long getMobile() {
        return mobile;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
    /**
     * 设置 {@link #opinion}
     *
     * @param opinion {@link #opinion}
     */
    public void setOpinion(String opinion) {
        this.opinion = opinion;
    }
    /**
     * 获取 {@link #opinion}
     *
     * @return {@link #opinion}
     */
    public String getOpinion() {
        return opinion;
    }
    /**
     * 设置 {@link #status}
     *
     * @param status {@link #status}
     */
    public void setStatus(Integer status) {
        this.status = status;
    }
    /**
     * 获取 {@link #status}
     *
     * @return {@link #status}
     */
    public Integer getStatus() {
        return status;
    }
    /**
     * 设置 {@link #unit}
     *
     * @param unit {@link #unit}
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 获取 {@link #unit}
     *
     * @return {@link #unit}
     */
    public String getUnit() {
        return unit;
    }

    public String getProposerId() {
        return proposerId;
    }

    public void setProposerId(String proposerId) {
        this.proposerId = proposerId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Override
    public Date getCreatedDate() {
        return createdDate;
    }

    @Override
    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }
}
