package com.tcbj.website.vo;

import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import com.cyberway.msf.commons.model.base.vo.BaseFullVo;
import io.swagger.annotations.ApiModelProperty;


import javax.validation.constraints.NotNull;
import java.util.Date;

/** 用户表完整字段VO */
@ApiModel("用户表完整字段VO")
public class MemberUserFullVo extends BaseFullVo {
    /** 邮箱 */
    @ApiModelProperty("邮箱")
    private String email;
    /** 是否删除 */
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 手机号码 */
    @ApiModelProperty("手机号码")
    private Long mobile;
    /** 名称 */
    @ApiModelProperty("名称")
    private String name;
    /** 密码 */
    @ApiModelProperty("密码")
    private String password;
    /** 角色 */
    @ApiModelProperty("角色：0-默认游客 1-会员 2-内部员工")
    private Integer role;
    /** 性别 */
    @ApiModelProperty("性别：0-男 1-女")
    private Integer sex;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createdDate;

    @ApiModelProperty("登录：0-未登录 1-登录")
    protected Integer online;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date lastModified;

    @ApiModelProperty("单位名称")
    private String unitName;

    @ApiModelProperty("职位名称")
    private String postName;

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }

    @Override
    public Date getLastModified() {
        return lastModified;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }
    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #mobile}
     *
     * @param mobile {@link #mobile}
     */
    public void setMobile(Long mobile) {
        this.mobile = mobile;
    }
    /**
     * 获取 {@link #mobile}
     *
     * @return {@link #mobile}
     */
    public Long getMobile() {
        return mobile;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
    /**
     * 设置 {@link #password}
     *
     * @param password {@link #password}
     */
    public void setPassword(String password) {
        this.password = password;
    }
    /**
     * 获取 {@link #password}
     *
     * @return {@link #password}
     */
    public String getPassword() {
        return password;
    }
    /**
     * 设置 {@link #role}
     *
     * @param role {@link #role}
     */
    public void setRole(Integer role) {
        this.role = role;
    }
    /**
     * 获取 {@link #role}
     *
     * @return {@link #role}
     */
    public Integer getRole() {
        return role;
    }
    /**
     * 设置 {@link #sex}
     *
     * @param sex {@link #sex}
     */
    public void setSex(Integer sex) {
        this.sex = sex;
    }
    /**
     * 获取 {@link #sex}
     *
     * @return {@link #sex}
     */
    public Integer getSex() {
        return sex;
    }

    @Override
    public Date getCreatedDate() {
        return createdDate;
    }

    @Override
    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }
    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getOnline() {
        return online;
    }

    public void setOnline(Integer online) {
        this.online = online;
    }
}
