package com.tcbj.website.vo;

import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import com.cyberway.msf.commons.model.base.vo.BaseFullVo;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;

/** 菜单栏目完整字段VO */
@ApiModel("菜单栏目完整字段VO")
public class MenuItemFullVo extends BaseFullVo {

    /** 描述 */
    @ApiModelProperty("描述")
    private String description;
    /** 是否删除 */
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文标签 */
    @ApiModelProperty("是否英文标签")
    private Integer isEn;
    /** 是否手机端显示 */
    @ApiModelProperty("是否手机端显示")
    private Integer isPhone;
    /** 所属一级栏目 */
    @ApiModelProperty("所属一级栏目")
    private String menuFirstItem;
    /** 所属一级栏目名称 */
    @ApiModelProperty("所属一级栏目名称")
    private String menuFirstItemName;
    /** 菜单级别 */
    @ApiModelProperty("菜单级别")
    private Integer menuLever;
    /** 所属二级栏目 */
    @ApiModelProperty("所属二级栏目")
    private String menuSecondItem;
    /** 所属二级栏目 */
    @ApiModelProperty("所属二级栏目名称")
    private String menuSecondItemName;
    /** 栏目序号 */
    @ApiModelProperty("栏目序号")
    private Integer menuSort;
    /** 栏目名称 */
    @ApiModelProperty("栏目名称")
    private String name;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date lastModified;

    /** 路由 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("路由")
    private String path;

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public Date getLastModified() {
        return lastModified;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    /**
     * 设置 {@link #description}
     *
     * @param description {@link #description}
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 获取 {@link #description}
     *
     * @return {@link #description}
     */
    public String getDescription() {
        return description;
    }
    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #isEn}
     *
     * @param isEn {@link #isEn}
     */
    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }
    /**
     * 获取 {@link #isEn}
     *
     * @return {@link #isEn}
     */
    public Integer getIsEn() {
        return isEn;
    }
    /**
     * 设置 {@link #isPhone}
     *
     * @param isPhone {@link #isPhone}
     */
    public void setIsPhone(Integer isPhone) {
        this.isPhone = isPhone;
    }
    /**
     * 获取 {@link #isPhone}
     *
     * @return {@link #isPhone}
     */
    public Integer getIsPhone() {
        return isPhone;
    }
    /**
     * 设置 {@link #menuFirstItem}
     *
     * @param menuFirstItem {@link #menuFirstItem}
     */
    public void setMenuFirstItem(String menuFirstItem) {
        this.menuFirstItem = menuFirstItem;
    }
    /**
     * 获取 {@link #menuFirstItem}
     *
     * @return {@link #menuFirstItem}
     */
    public String getMenuFirstItem() {
        return menuFirstItem;
    }
    /**
     * 设置 {@link #menuLever}
     *
     * @param menuLever {@link #menuLever}
     */
    public void setMenuLever(Integer menuLever) {
        this.menuLever = menuLever;
    }
    /**
     * 获取 {@link #menuLever}
     *
     * @return {@link #menuLever}
     */
    public Integer getMenuLever() {
        return menuLever;
    }
    /**
     * 设置 {@link #menuSecondItem}
     *
     * @param menuSecondItem {@link #menuSecondItem}
     */
    public void setMenuSecondItem(String menuSecondItem) {
        this.menuSecondItem = menuSecondItem;
    }
    /**
     * 获取 {@link #menuSecondItem}
     *
     * @return {@link #menuSecondItem}
     */
    public String getMenuSecondItem() {
        return menuSecondItem;
    }
    /**
     * 设置 {@link #menuSort}
     *
     * @param menuSort {@link #menuSort}
     */
    public void setMenuSort(Integer menuSort) {
        this.menuSort = menuSort;
    }
    /**
     * 获取 {@link #menuSort}
     *
     * @return {@link #menuSort}
     */
    public Integer getMenuSort() {
        return menuSort;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }

    public String getMenuFirstItemName() {
        return menuFirstItemName;
    }

    public void setMenuFirstItemName(String menuFirstItemName) {
        this.menuFirstItemName = menuFirstItemName;
    }

    public String getMenuSecondItemName() {
        return menuSecondItemName;
    }

    public void setMenuSecondItemName(String menuSecondItemName) {
        this.menuSecondItemName = menuSecondItemName;
    }
}
