package com.tcbj.website.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import com.cyberway.msf.commons.model.base.vo.BaseFullVo;
import io.swagger.annotations.ApiModelProperty;
import com.tcbj.website.vo.PopularWordsGroupSimpleVo;

import java.util.Date;

/** 热搜词完整字段VO */
@ApiModel("热搜词完整字段VO")
public class PopularWordsFullVo extends BaseFullVo {

    /** 描述 */
    @ApiModelProperty("描述")
    private String description;
    /** 是否删除 */
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文标签 */
    @ApiModelProperty("是否英文标签")
    private Integer isEn;
    /** 名称 */
    @ApiModelProperty("名称")
    private String name;
    /** 热搜词分组 */
    @ApiModelProperty("热搜词分组")
    private PopularWordsGroupSimpleVo popularWordsGroup;
    /** 排序 */
    @ApiModelProperty("排序")
    private Integer wordsSort;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date lastModified;

    @Override
    public Date getLastModified() {
        return lastModified;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    /**
     * 设置 {@link #description}
     *
     * @param description {@link #description}
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 获取 {@link #description}
     *
     * @return {@link #description}
     */
    public String getDescription() {
        return description;
    }
    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #isEn}
     *
     * @param isEn {@link #isEn}
     */
    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }
    /**
     * 获取 {@link #isEn}
     *
     * @return {@link #isEn}
     */
    public Integer getIsEn() {
        return isEn;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
    /**
     * 设置 {@link #popularWordsGroup}
     *
     * @param popularWordsGroup {@link #popularWordsGroup}
     */
    public void setPopularWordsGroup(PopularWordsGroupSimpleVo popularWordsGroup) {
        this.popularWordsGroup = popularWordsGroup;
    }
    /**
     * 获取 {@link #popularWordsGroup}
     *
     * @return {@link #popularWordsGroup}
     */
    public PopularWordsGroupSimpleVo getPopularWordsGroup() {
        return popularWordsGroup;
    }
    /**
     * 设置 {@link #wordsSort}
     *
     * @param wordsSort {@link #wordsSort}
     */
    public void setWordsSort(Integer wordsSort) {
        this.wordsSort = wordsSort;
    }
    /**
     * 获取 {@link #wordsSort}
     *
     * @return {@link #wordsSort}
     */
    public Integer getWordsSort() {
        return wordsSort;
    }
}
