package com.tcbj.website.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.util.Date;
import java.util.List;

/** 知识库搜索结果返回 */
@ApiModel("知识库搜索结果返回简单字段VO")
public class WebsiteSearchForKnowledgeVo {

    @ApiModelProperty("文章类别一级标题")
    private String articleCategoryFirstName;

    @ApiModelProperty("文章类别二级标题")
    private String articleCategorySecondName;
    /** 文章标签 */
    @ApiModelProperty("文章标签")
    private List<ArticleContentLabelSimpleForKnowledgeVo> articleLabel;

    /** 简介 */
    @ApiModelProperty("简介")
    private String description;

    /** 阅读量 */
    @ApiModelProperty("阅读量")
    private Integer hits;

    /** 标题 */
    @ApiModelProperty("标题")
    private String name;

    /** id */
    @ApiModelProperty("文章id")
    private String id;

    /** 发布时间 */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("发布时间")
    private Date releaseTime;
    /** 一级栏目ID */
    @ApiModelProperty("一级栏目ID")
    private String menuFirstItemId;
    /** 一级栏目ID */
    @ApiModelProperty("一级栏目名称")
    private String menuFirstItemName;
    /** 一级栏目ID */
    @ApiModelProperty("二级栏目ID")
    private String menuItemId;
    /** 一级栏目ID */
    @ApiModelProperty("一级栏目名称")
    private String menuItemName;
    /** 二级栏目名称 */
    @ApiModelProperty("二级栏目名称")
    private String menuSecondItemName;

    @ApiModelProperty("三级栏目id")
    private String menuThreeItemId;

    @ApiModelProperty("所属三级级栏目名称")
    private String  menuThreeItemName;


    @ApiModelProperty("出版社名称(知识库专用字段)")
    private String pressName;

    /** 内容 */
    @ApiModelProperty("内容")
    private String content;

    /** pdf文件 */
    @ApiModelProperty("pdf文件")
    private String pdf;


    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getPdf() {
        return pdf;
    }

    public void setPdf(String pdf) {
        this.pdf = pdf;
    }

    public String getPressName() {
        return pressName;
    }

    public void setPressName(String pressName) {
        this.pressName = pressName;
    }

    public String getArticleCategoryFirstName() {
        return articleCategoryFirstName;
    }

    public void setArticleCategoryFirstName(String articleCategoryFirstName) {
        this.articleCategoryFirstName = articleCategoryFirstName;
    }

    public String getArticleCategorySecondName() {
        return articleCategorySecondName;
    }

    public void setArticleCategorySecondName(String articleCategorySecondName) {
        this.articleCategorySecondName = articleCategorySecondName;
    }

    public List<ArticleContentLabelSimpleForKnowledgeVo> getArticleLabel() {
        return articleLabel;
    }

    public void setArticleLabel(List<ArticleContentLabelSimpleForKnowledgeVo> articleLabel) {
        this.articleLabel = articleLabel;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getHits() {
        return hits;
    }

    public void setHits(Integer hits) {
        this.hits = hits;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getReleaseTime() {
        return releaseTime;
    }

    public void setReleaseTime(Date releaseTime) {
        this.releaseTime = releaseTime;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMenuFirstItemId() {
        return menuFirstItemId;
    }

    public void setMenuFirstItemId(String menuFirstItemId) {
        this.menuFirstItemId = menuFirstItemId;
    }

    public String getMenuFirstItemName() {
        return menuFirstItemName;
    }

    public void setMenuFirstItemName(String menuFirstItemName) {
        this.menuFirstItemName = menuFirstItemName;
    }

    public String getMenuThreeItemId() {
        return menuThreeItemId;
    }

    public void setMenuThreeItemId(String menuThreeItemId) {
        this.menuThreeItemId = menuThreeItemId;
    }

    public String getMenuItemId() {
        return menuItemId;
    }

    public void setMenuItemId(String menuItemId) {
        this.menuItemId = menuItemId;
    }

    public String getMenuItemName() {
        return menuItemName;
    }

    public void setMenuItemName(String menuItemName) {
        this.menuItemName = menuItemName;
    }

    public String getMenuSecondItemName() {
        return menuSecondItemName;
    }

    public void setMenuSecondItemName(String menuSecondItemName) {
        this.menuSecondItemName = menuSecondItemName;
    }

    public String getMenuThreeItemName() {
        return menuThreeItemName;
    }

    public void setMenuThreeItemName(String menuThreeItemName) {
        this.menuThreeItemName = menuThreeItemName;
    }
}
