package com.tcbj.website.client;

import org.springframework.cloud.openfeign.FeignClient;
import com.cyberway.msf.commons.client.BaseVoClient;
import com.tcbj.website.model.Attachment;
import com.cyberway.msf.commons.api.result.ApiResponseResult;
import org.springframework.web.bind.annotation.PostMapping;
import com.tcbj.website.dto.AttachmentSaveDto;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.PathVariable;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.tcbj.website.vo.AttachmentSimpleVo;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.tcbj.website.vo.AttachmentFullVo;
import org.springframework.web.bind.annotation.GetMapping;
import com.tcbj.website.vo.AttachmentMinVo;
import java.util.Map;
import java.util.Set;

/** 上传附件表Feign客户端 */
@FeignClient(
        contextId = "AttachmentClient",
        name = "${feign.website:tcbj-website}",
        path = "api/attachment")
public interface AttachmentClient extends BaseVoClient<Attachment> {

    /**
     * 新增实体
     *
     * @return 实体ID
     */
    @PostMapping
    ApiResponseResult<String> insert(@RequestBody AttachmentSaveDto dto);
    /**
     * 更新提交参数中非空实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/{id}")
    ApiResponseResult<Integer> update(
            @PathVariable("id") String id, @RequestBody AttachmentSaveDto dto);
    /**
     * 更新所有实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/updateAll/{id}")
    ApiResponseResult<Integer> updateAll(
            @PathVariable("id") String id, @RequestBody AttachmentSaveDto dto);
    /**
     * 列表查询接口
     *
     * @return 实体列表
     */
    @PostMapping("/list")
    ApiResponseResult<PageDataModel<AttachmentSimpleVo>> list(@RequestBody FilterModel filterModel);
    /**
     * 详情
     *
     * @return 实体完整详情数据
     */
    @GetMapping("/{id}")
    ApiResponseResult<AttachmentFullVo> detail(@PathVariable("id") String id);
    /**
     * 简单字段详情
     *
     * @return 实体简单字段详情数据
     */
    @GetMapping("/{id}/simple")
    ApiResponseResult<AttachmentSimpleVo> getSimpleVo(@PathVariable("id") String id);
    /**
     * 最小字段详情
     *
     * @return 实体最小字段详情数据
     */
    @GetMapping("/{id}/min")
    ApiResponseResult<AttachmentMinVo> getMinVo(@PathVariable("id") String id);
    /**
     * 根据ID集合获取对应MinVo
     *
     * @return Map, key为ID, value为MinVo
     */
    @PostMapping("/getMinVoMapByIdSet")
    ApiResponseResult<Map<String, AttachmentMinVo>> getMinVoMapByIdSet(
            @RequestBody Set<String> idSet);
}
