package com.tcbj.website.client;

import org.springframework.cloud.openfeign.FeignClient;
import com.cyberway.msf.commons.client.BaseVoClient;
import com.tcbj.website.model.FundTemplate;
import com.cyberway.msf.commons.api.result.ApiResponseResult;
import org.springframework.web.bind.annotation.PostMapping;
import com.tcbj.website.dto.FundTemplateSaveDto;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.PathVariable;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.tcbj.website.vo.FundTemplateSimpleVo;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.tcbj.website.vo.FundTemplateFullVo;
import org.springframework.web.bind.annotation.GetMapping;
import com.tcbj.website.vo.FundTemplateMinVo;
import java.util.Map;
import java.util.Set;

/** 基金模板Feign客户端 */
@FeignClient(
        contextId = "FundTemplateClient",
        name = "${feign.website:tcbj-website}",
        path = "api/fundTemplate")
public interface FundTemplateClient extends BaseVoClient<FundTemplate> {

    /**
     * 新增实体
     *
     * @return 实体ID
     */
    @PostMapping
    ApiResponseResult<String> insert(@RequestBody FundTemplateSaveDto dto);
    /**
     * 更新提交参数中非空实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/{id}")
    ApiResponseResult<Integer> update(
            @PathVariable("id") String id, @RequestBody FundTemplateSaveDto dto);
    /**
     * 更新所有实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/updateAll/{id}")
    ApiResponseResult<Integer> updateAll(
            @PathVariable("id") String id, @RequestBody FundTemplateSaveDto dto);
    /**
     * 列表查询接口
     *
     * @return 实体列表
     */
    @PostMapping("/list")
    ApiResponseResult<PageDataModel<FundTemplateSimpleVo>> list(
            @RequestBody FilterModel filterModel);
    /**
     * 详情
     *
     * @return 实体完整详情数据
     */
    @GetMapping("/{id}")
    ApiResponseResult<FundTemplateFullVo> detail(@PathVariable("id") String id);
    /**
     * 简单字段详情
     *
     * @return 实体简单字段详情数据
     */
    @GetMapping("/{id}/simple")
    ApiResponseResult<FundTemplateSimpleVo> getSimpleVo(@PathVariable("id") String id);
    /**
     * 最小字段详情
     *
     * @return 实体最小字段详情数据
     */
    @GetMapping("/{id}/min")
    ApiResponseResult<FundTemplateMinVo> getMinVo(@PathVariable("id") String id);
    /**
     * 根据ID集合获取对应MinVo
     *
     * @return Map, key为ID, value为MinVo
     */
    @PostMapping("/getMinVoMapByIdSet")
    ApiResponseResult<Map<String, FundTemplateMinVo>> getMinVoMapByIdSet(
            @RequestBody Set<String> idSet);
}
