package com.tcbj.website.client;

import org.springframework.cloud.openfeign.FeignClient;
import com.cyberway.msf.commons.client.BaseVoClient;
import com.tcbj.website.model.InnovationEnglish;
import com.cyberway.msf.commons.api.result.ApiResponseResult;
import org.springframework.web.bind.annotation.PostMapping;
import com.tcbj.website.dto.InnovationEnglishSaveDto;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.PathVariable;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.tcbj.website.vo.InnovationEnglishSimpleVo;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.tcbj.website.vo.InnovationEnglishFullVo;
import org.springframework.web.bind.annotation.GetMapping;

/** 创新研究Feign客户端 */
@FeignClient(
        contextId = "InnovationEnglishClient",
        name = "${feign.website:tcbj-website}",
        path = "api/innovationEnglish")
public interface InnovationEnglishClient extends BaseVoClient<InnovationEnglish> {

    /**
     * 新增实体
     *
     * @return 实体ID
     */
    @PostMapping
    ApiResponseResult<String> insert(@RequestBody InnovationEnglishSaveDto dto);
    /**
     * 更新提交参数中非空实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/{id}")
    ApiResponseResult<Integer> update(
            @PathVariable("id") String id, @RequestBody InnovationEnglishSaveDto dto);
    /**
     * 更新所有实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/updateAll/{id}")
    ApiResponseResult<Integer> updateAll(
            @PathVariable("id") String id, @RequestBody InnovationEnglishSaveDto dto);
    /**
     * 列表查询接口
     *
     * @return 实体列表
     */
    @PostMapping("/list")
    ApiResponseResult<PageDataModel<InnovationEnglishSimpleVo>> list(
            @RequestBody FilterModel filterModel);
    /**
     * 详情
     *
     * @return 实体完整详情数据
     */
    @GetMapping("/{id}")
    ApiResponseResult<InnovationEnglishFullVo> detail(@PathVariable("id") String id);
    /**
     * 简单字段详情
     *
     * @return 实体简单字段详情数据
     */
    @GetMapping("/{id}/simple")
    ApiResponseResult<InnovationEnglishSimpleVo> getSimpleVo(@PathVariable("id") String id);
}
