package com.tcbj.website.client;

import com.cyberway.msf.commons.api.result.ApiResponseResult;
import com.cyberway.msf.commons.client.BaseVoClient;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.tcbj.website.dto.ArticleContentSaveDto;
import com.tcbj.website.dto.KnowledgeLogQueryDto;
import com.tcbj.website.dto.KnowledgeLogSaveDto;
import com.tcbj.website.dto.LabelSaveDto;
import com.tcbj.website.model.ArticleContent;
import com.tcbj.website.model.KnowledgeLog;
import com.tcbj.website.vo.ArticleContentFullVo;
import com.tcbj.website.vo.ArticleContentMinVo;
import com.tcbj.website.vo.ArticleContentSimpleVo;
import com.tcbj.website.vo.KnowledgeLogFullVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.Map;
import java.util.Set;

/** 文章内容Feign客户端 */
@FeignClient(
        contextId = "KnowledgeLogClient",
        name = "${feign.website:tcbj-website}",
        path = "api/knowledgeLog")
public interface KnowledgeLogClient extends BaseVoClient<KnowledgeLog> {

    /**
     * 新增实体
     *
     * @return 实体ID
     */
    @PostMapping
    ApiResponseResult<String> insert(@RequestBody KnowledgeLogSaveDto dto);

    /**
     * 新增实体
     *
     * @return 实体ID
     */
    @PostMapping
    ApiResponseResult<PageDataModel<KnowledgeLogFullVo>> pageList(@RequestBody KnowledgeLogQueryDto dto);


}
