package com.tcbj.website.client;

import org.springframework.cloud.openfeign.FeignClient;
import com.cyberway.msf.commons.client.BaseVoClient;
import com.tcbj.website.model.MemberUser;
import com.cyberway.msf.commons.api.result.ApiResponseResult;
import org.springframework.web.bind.annotation.PostMapping;
import com.tcbj.website.dto.MemberUserSaveDto;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.PathVariable;
import com.cyberway.msf.commons.model.page.PageDataModel;
import com.tcbj.website.vo.MemberUserSimpleVo;
import com.cyberway.msf.commons.model.filter.FilterModel;
import com.tcbj.website.vo.MemberUserFullVo;
import org.springframework.web.bind.annotation.GetMapping;
import com.tcbj.website.vo.MemberUserMinVo;
import java.util.Map;
import java.util.Set;

/** 用户表Feign客户端 */
@FeignClient(
        contextId = "MemberUserClient",
        name = "${feign.website:tcbj-website}",
        path = "api/memberUser")
public interface MemberUserClient extends BaseVoClient<MemberUser> {

    /**
     * 新增实体
     *
     * @return 实体ID
     */
    @PostMapping
    ApiResponseResult<String> insert(@RequestBody MemberUserSaveDto dto);
    /**
     * 更新提交参数中非空实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/{id}")
    ApiResponseResult<Integer> update(
            @PathVariable("id") String id, @RequestBody MemberUserSaveDto dto);
    /**
     * 更新所有实体字段
     *
     * @return 更新记录数
     */
    @PutMapping("/updateAll/{id}")
    ApiResponseResult<Integer> updateAll(
            @PathVariable("id") String id, @RequestBody MemberUserSaveDto dto);
    /**
     * 列表查询接口
     *
     * @return 实体列表
     */
    @PostMapping("/list")
    ApiResponseResult<PageDataModel<MemberUserSimpleVo>> list(@RequestBody FilterModel filterModel);
    /**
     * 详情
     *
     * @return 实体完整详情数据
     */
    @GetMapping("/{id}")
    ApiResponseResult<MemberUserFullVo> detail(@PathVariable("id") String id);
    /**
     * 简单字段详情
     *
     * @return 实体简单字段详情数据
     */
    @GetMapping("/{id}/simple")
    ApiResponseResult<MemberUserSimpleVo> getSimpleVo(@PathVariable("id") String id);
    /**
     * 最小字段详情
     *
     * @return 实体最小字段详情数据
     */
    @GetMapping("/{id}/min")
    ApiResponseResult<MemberUserMinVo> getMinVo(@PathVariable("id") String id);
    /**
     * 根据ID集合获取对应MinVo
     *
     * @return Map, key为ID, value为MinVo
     */
    @PostMapping("/getMinVoMapByIdSet")
    ApiResponseResult<Map<String, MemberUserMinVo>> getMinVoMapByIdSet(
            @RequestBody Set<String> idSet);
}
