package com.tcbj.website.dto;

import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.validation.constraints.NotNull;
import java.util.Date;


public class ArticleContentPageModel extends PageModel {
    /** 文章类别 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文章类别")
    private String articleCategoryId;
    /** 文章标签 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文章标签")
    private String articleLabelId;
    /** 内容 */
    @ApiModelProperty("内容")
    private String content;
    /** 是否删除 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文")
    private Integer isEn;
    /** 是否置顶 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否置顶")
    private Integer isStick;
    /** 所属栏目 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("所属栏目")
    private String menuItemId;
    /** 标题 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("标题")
    private String name;
    /** 合作机构 */
    @ApiModelProperty("合作机构")
    private String operating;
    /** 发布时间 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("发行时间")
    private Date releaseTime;
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("上架时间")
    private Date shelfTime;
    /** 所属权限 */
    @ApiModelProperty("所属权限")
    private Integer role;
    /** 状态 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("状态：0-草稿 1-未发布 2-预约发布 3-已发布  4-取消发布")
    private Integer status;
    /** 视频分组ID */
    @ApiModelProperty("视频分组ID")
    private String videoGroupId;
    /** 所属一级栏目id */
    @ApiModelProperty("所属一级栏目id")
    private String menuFirstItemId;
    /** 所属二级栏目 */
    @ApiModelProperty("所属二级栏目id")
    private String menuSecondItemId;

    @ApiModelProperty("所属三级级栏目id")
    private String  menuThreeItemId;
    /** 菜单级别 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("菜单级别")
    private Integer menuLever;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文")
    private Integer isPhone;
    @ApiModelProperty("二维码地址")
    private String qrCode;
    @ApiModelProperty("视频：是否展示首页")
    private Integer isHome;

    public Integer getIsHome() {
        return isHome;
    }

    public void setIsHome(Integer isHome) {
        this.isHome = isHome;
    }

    public String getQrCode() {
        return qrCode;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    public String getArticleCategoryId() {
        return articleCategoryId;
    }

    public void setArticleCategoryId(String articleCategoryId) {
        this.articleCategoryId = articleCategoryId;
    }

    public String getArticleLabelId() {
        return articleLabelId;
    }

    public void setArticleLabelId(String articleLabelId) {
        this.articleLabelId = articleLabelId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public Integer getIsEn() {
        return isEn;
    }

    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }

    public Integer getIsStick() {
        return isStick;
    }

    public void setIsStick(Integer isStick) {
        this.isStick = isStick;
    }

    public String getMenuItemId() {
        return menuItemId;
    }

    public void setMenuItemId(String menuItemId) {
        this.menuItemId = menuItemId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOperating() {
        return operating;
    }

    public void setOperating(String operating) {
        this.operating = operating;
    }

    public Date getReleaseTime() {
        return releaseTime;
    }

    public void setReleaseTime(Date releaseTime) {
        this.releaseTime = releaseTime;
    }

    public Date getShelfTime() {
        return shelfTime;
    }

    public void setShelfTime(Date shelfTime) {
        this.shelfTime = shelfTime;
    }

    public Integer getRole() {
        return role;
    }

    public void setRole(Integer role) {
        this.role = role;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getVideoGroupId() {
        return videoGroupId;
    }

    public void setVideoGroupId(String videoGroupId) {
        this.videoGroupId = videoGroupId;
    }

    public String getMenuFirstItemId() {
        return menuFirstItemId;
    }

    public void setMenuFirstItemId(String menuFirstItemId) {
        this.menuFirstItemId = menuFirstItemId;
    }

    public Integer getMenuLever() {
        return menuLever;
    }

    public void setMenuLever(Integer menuLever) {
        this.menuLever = menuLever;
    }

    public String getMenuSecondItemId() {
        return menuSecondItemId;
    }

    public void setMenuSecondItemId(String menuSecondItemId) {
        this.menuSecondItemId = menuSecondItemId;
    }

    public String getMenuThreeItemId() {
        return menuThreeItemId;
    }

    public void setMenuThreeItemId(String menuThreeItemId) {
        this.menuThreeItemId = menuThreeItemId;
    }

    public Integer getIsPhone() {
        return isPhone;
    }

    public void setIsPhone(Integer isPhone) {
        this.isPhone = isPhone;
    }
}
