package com.tcbj.website.dto;

import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;

/** 基金模板分页查询DTO */
@ApiModel("基金模板分页查询DTO")
public class FundTemplateQueryPageDto extends PageModel {

    /** 项目唯一编码 */
    @ApiModelProperty("项目唯一编码")
    private String code;
    /** 是否删除 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文")
    private Integer isEn;
    /** 状态 0：草稿 1：发布*/
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("状态 0：草稿 1：发布")
    private Integer status;
    /** 项目名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("项目名称")
    private String name;
    /** 项目所属年份 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("项目所属年份")
    private String releaseyear;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public Integer getIsEn() {
        return isEn;
    }

    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReleaseyear() {
        return releaseyear;
    }

    public void setReleaseyear(String releaseyear) {
        this.releaseyear = releaseyear;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
