package com.tcbj.website.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;

/** 用户表新增修改DTO */
@ApiModel("用户表新增修改DTO")
public class MemberUserSaveDto {

    /** 邮箱 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("邮箱")
    private String email;

    /** 是否删除 */
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 手机号码 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("手机号码")
    private Long mobile;
    /** 名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("名称")
    private String name;
    /** 密码 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("密码")
    private String password;

    /** 新密码 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("密码")
    private String newPassword;

    /** 角色 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("角色：0-默认游客 1-会员 2-内部员工")
    private Integer role;
    /** 性别 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("性别：0-男 1-女")
    private Integer sex;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("登录：0-未登录 1-登录")
    protected Integer online;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("单位名称")
    private String unitName;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("职位名称")
    private String postName;

    /** esb平台密码 */
    @ApiModelProperty("esb平台账号")
    private String esbAccount;

    /** esb平台密码 */
    @ApiModelProperty("esb平台密码")
    private String esbPassword;

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }

    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #mobile}
     *
     * @param mobile {@link #mobile}
     */
    public void setMobile(Long mobile) {
        this.mobile = mobile;
    }
    /**
     * 获取 {@link #mobile}
     *
     * @return {@link #mobile}
     */
    public Long getMobile() {
        return mobile;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
    /**
     * 设置 {@link #password}
     *
     * @param password {@link #password}
     */
    public void setPassword(String password) {
        this.password = password;
    }
    /**
     * 获取 {@link #password}
     *
     * @return {@link #password}
     */
    public String getPassword() {
        return password;
    }
    /**
     * 设置 {@link #role}
     *
     * @param role {@link #role}
     */
    public void setRole(Integer role) {
        this.role = role;
    }
    /**
     * 获取 {@link #role}
     *
     * @return {@link #role}
     */
    public Integer getRole() {
        return role;
    }
    /**
     * 设置 {@link #sex}
     *
     * @param sex {@link #sex}
     */
    public void setSex(Integer sex) {
        this.sex = sex;
    }
    /**
     * 获取 {@link #sex}
     *
     * @return {@link #sex}
     */
    public Integer getSex() {
        return sex;
    }

    public String getNewPassword() {
        return newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getOnline() {
        return online;
    }

    public void setOnline(Integer online) {
        this.online = online;
    }

    public String getEsbPassword() {
        return esbPassword;
    }

    public void setEsbPassword(String esbPassword) {
        this.esbPassword = esbPassword;
    }

    public String getEsbAccount() {
        return esbAccount;
    }

    public void setEsbAccount(String esbAccount) {
        this.esbAccount = esbAccount;
    }
}
