package com.tcbj.website.dto;


import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/** 菜单栏目新增修改DTO */
@ApiModel("菜单栏目分页查询DTO")
public class MenuItemQueryPageDto extends PageModel {

    /** 是否删除 */
    @ApiModelProperty("是否删除 0:否 1：是")
    private Integer isDelete;
    /** 是否英文标签 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文标签 0:否 1：是")
    private Integer isEn;
    /** 是否手机端显示 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否手机端显示 0:否 1：是")
    private Integer isPhone;
    /** 所属一级栏目 */
    @ApiModelProperty("所属一级栏目id 不能修改 不显示")
    private String menuFirstItem;

    /** 菜单级别 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("菜单级别 不能修改")
    private Integer menuLever;
    /** 所属二级栏目 */
    @ApiModelProperty("所属二级栏目id 不能修改 不显示")
    private String menuSecondItem;


    /** 栏目名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("栏目名称")
    private String name;


    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #isEn}
     *
     * @param isEn {@link #isEn}
     */
    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }
    /**
     * 获取 {@link #isEn}
     *
     * @return {@link #isEn}
     */
    public Integer getIsEn() {
        return isEn;
    }
    /**
     * 设置 {@link #isPhone}
     *
     * @param isPhone {@link #isPhone}
     */
    public void setIsPhone(Integer isPhone) {
        this.isPhone = isPhone;
    }
    /**
     * 获取 {@link #isPhone}
     *
     * @return {@link #isPhone}
     */
    public Integer getIsPhone() {
        return isPhone;
    }
    /**
     * 设置 {@link #menuFirstItem}
     *
     * @param menuFirstItem {@link #menuFirstItem}
     */
    public void setMenuFirstItem(String menuFirstItem) {
        this.menuFirstItem = menuFirstItem;
    }
    /**
     * 获取 {@link #menuFirstItem}
     *
     * @return {@link #menuFirstItem}
     */
    public String getMenuFirstItem() {
        return menuFirstItem;
    }
    /**
     * 设置 {@link #menuLever}
     *
     * @param menuLever {@link #menuLever}
     */
    public void setMenuLever(Integer menuLever) {
        this.menuLever = menuLever;
    }
    /**
     * 获取 {@link #menuLever}
     *
     * @return {@link #menuLever}
     */
    public Integer getMenuLever() {
        return menuLever;
    }
    /**
     * 设置 {@link #menuSecondItem}
     *
     * @param menuSecondItem {@link #menuSecondItem}
     */
    public void setMenuSecondItem(String menuSecondItem) {
        this.menuSecondItem = menuSecondItem;
    }

    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }



    public String getMenuSecondItem() {
        return menuSecondItem;
    }

}
