package com.tcbj.website.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;

/** 菜单栏目新增修改DTO */
@ApiModel("菜单栏目新增修改DTO")
public class MenuItemSaveDto {

    /** 描述 */
    @ApiModelProperty("描述")
    private String description;
    /** 是否删除 */
    @ApiModelProperty("是否删除 0:否 1：是")
    private Integer isDelete;
    /** 是否英文标签 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文标签 0:否 1：是")
    private Integer isEn;
    /** 是否手机端显示 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否手机端显示 0:否 1：是")
    private Integer isPhone;
    /** 所属一级栏目 */
    @ApiModelProperty("所属一级栏目 不能修改 不显示")
    private String menuFirstItem;

    /** 所属一级栏目名称 */
    @ApiModelProperty("所属一级栏目名称 不能修改 一级栏目不显示")
    private String menuFirstItemName;
    /** 菜单级别 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("菜单级别 不能修改 ")
    private Integer menuLever;
    /** 所属二级栏目 */
    @ApiModelProperty("所属二级栏目 不能修改 不显示")
    private String menuSecondItem;
    /** 所属二级栏目 */
    @ApiModelProperty("所属二级栏目名称 不能修改 一二级栏目不显示")
    private String menuSecondItemName;
    /** 栏目序号 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("栏目序号 ")
    private Integer menuSort;
    /** 栏目名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("栏目名称")
    private String name;

    /** 路由 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("路由")
    private String path;

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }


    /**
     * 设置 {@link #description}
     *
     * @param description {@link #description}
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 获取 {@link #description}
     *
     * @return {@link #description}
     */
    public String getDescription() {
        return description;
    }
    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #isEn}
     *
     * @param isEn {@link #isEn}
     */
    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }
    /**
     * 获取 {@link #isEn}
     *
     * @return {@link #isEn}
     */
    public Integer getIsEn() {
        return isEn;
    }
    /**
     * 设置 {@link #isPhone}
     *
     * @param isPhone {@link #isPhone}
     */
    public void setIsPhone(Integer isPhone) {
        this.isPhone = isPhone;
    }
    /**
     * 获取 {@link #isPhone}
     *
     * @return {@link #isPhone}
     */
    public Integer getIsPhone() {
        return isPhone;
    }
    /**
     * 设置 {@link #menuFirstItem}
     *
     * @param menuFirstItem {@link #menuFirstItem}
     */
    public void setMenuFirstItem(String menuFirstItem) {
        this.menuFirstItem = menuFirstItem;
    }
    /**
     * 获取 {@link #menuFirstItem}
     *
     * @return {@link #menuFirstItem}
     */
    public String getMenuFirstItem() {
        return menuFirstItem;
    }
    /**
     * 设置 {@link #menuLever}
     *
     * @param menuLever {@link #menuLever}
     */
    public void setMenuLever(Integer menuLever) {
        this.menuLever = menuLever;
    }
    /**
     * 获取 {@link #menuLever}
     *
     * @return {@link #menuLever}
     */
    public Integer getMenuLever() {
        return menuLever;
    }
    /**
     * 设置 {@link #menuSecondItem}
     *
     * @param menuSecondItem {@link #menuSecondItem}
     */
    public void setMenuSecondItem(String menuSecondItem) {
        this.menuSecondItem = menuSecondItem;
    }
    /**
     * 获取 {@link #menuSecondItem}
     *
     * @return {@link #menuSecondItem}
     */
    public String getMenuSecondItem() {
        return menuSecondItem;
    }
    /**
     * 设置 {@link #menuSort}
     *
     * @param menuSort {@link #menuSort}
     */
    public void setMenuSort(Integer menuSort) {
        this.menuSort = menuSort;
    }
    /**
     * 获取 {@link #menuSort}
     *
     * @return {@link #menuSort}
     */
    public Integer getMenuSort() {
        return menuSort;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }

    public String getMenuFirstItemName() {
        return menuFirstItemName;
    }

    public void setMenuFirstItemName(String menuFirstItemName) {
        this.menuFirstItemName = menuFirstItemName;
    }

    public String getMenuSecondItemName() {
        return menuSecondItemName;
    }

    public void setMenuSecondItemName(String menuSecondItemName) {
        this.menuSecondItemName = menuSecondItemName;
    }
}
