package com.tcbj.website.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;

/** 热搜词分组新增修改DTO */
@ApiModel("热搜词分组新增修改DTO")
public class PopularWordsGroupSaveDto {

    /** 描述 */
    @ApiModelProperty("描述")
    private String description;
    /** 排序 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("排序")
    private Integer groupSort;
    /** 是否删除 */
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文标签 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文标签")
    private Integer isEn;
    /** 分组名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("分组名称")
    private String name;

    /**
     * 设置 {@link #description}
     *
     * @param description {@link #description}
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 获取 {@link #description}
     *
     * @return {@link #description}
     */
    public String getDescription() {
        return description;
    }
    /**
     * 设置 {@link #groupSort}
     *
     * @param groupSort {@link #groupSort}
     */
    public void setGroupSort(Integer groupSort) {
        this.groupSort = groupSort;
    }
    /**
     * 获取 {@link #groupSort}
     *
     * @return {@link #groupSort}
     */
    public Integer getGroupSort() {
        return groupSort;
    }
    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #isEn}
     *
     * @param isEn {@link #isEn}
     */
    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }
    /**
     * 获取 {@link #isEn}
     *
     * @return {@link #isEn}
     */
    public Integer getIsEn() {
        return isEn;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
}
