package com.tcbj.website.dto;

import com.cyberway.msf.commons.model.page.PageModel;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

public class PopularWordsPageModel extends PageModel {

    /** 描述 */
    @ApiModelProperty("描述")
    private String description;
    /** 是否删除 */
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文标签 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否英文标签")
    private Integer isEn;
    /** 名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("名称")
    private String name;
    /** 热搜词分组 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("热搜词分组")
    private String popularWordsGroupId;
    /** 排序 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("排序")
    private Integer wordsSort;

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public Integer getIsEn() {
        return isEn;
    }

    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPopularWordsGroupId() {
        return popularWordsGroupId;
    }

    public void setPopularWordsGroupId(String popularWordsGroupId) {
        this.popularWordsGroupId = popularWordsGroupId;
    }

    public Integer getWordsSort() {
        return wordsSort;
    }

    public void setWordsSort(Integer wordsSort) {
        this.wordsSort = wordsSort;
    }
}
