package com.tcbj.website.model;

import com.cyberway.msf.commons.model.base.BusinessEntityWithOrganization;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import tk.mybatis.mapper.annotation.NameStyle;
import tk.mybatis.mapper.code.Style;

import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;

/** 文章与标签关联表 */
@Table(name = "website_article_content_menu")
@NameStyle(Style.normal)
@ApiModel("文章与标签关联表")
public class ArticleContentMenu extends BusinessEntityWithOrganization {

    /** 文章ID */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文章ID")
    private String articleContentId;

    /** 一级栏目名称 */
    @ApiModelProperty("一级栏目Id")
    private String menuFirstItemId;
    /** 一级栏目名称 */
    @ApiModelProperty("一级栏目名称")
    private String menuFirstItemName;
    /** 二级栏目名称 */
    @ApiModelProperty("二级栏目id")
    private String menuSecondItemId;
    /** 二级栏目名称 */
    @ApiModelProperty("二级栏目名称")
    private String menuSecondItemName;

    @ApiModelProperty("所属三级级栏目id")
    private String  menuThreeItemId;

    @ApiModelProperty("所属三级级栏目名称")
    private String  menuThreeItemName;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("所属栏目id")
    private String menuItemId;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("所属栏目名称")
    private String menuItemName;


    public String getArticleContentId() {
        return articleContentId;
    }

    public void setArticleContentId(String articleContentId) {
        this.articleContentId = articleContentId;
    }

    public String getMenuFirstItemId() {
        return menuFirstItemId;
    }

    public void setMenuFirstItemId(String menuFirstItemId) {
        this.menuFirstItemId = menuFirstItemId;
    }

    public String getMenuFirstItemName() {
        return menuFirstItemName;
    }

    public void setMenuFirstItemName(String menuFirstItemName) {
        this.menuFirstItemName = menuFirstItemName;
    }

    public String getMenuSecondItemId() {
        return menuSecondItemId;
    }

    public void setMenuSecondItemId(String menuSecondItemId) {
        this.menuSecondItemId = menuSecondItemId;
    }

    public String getMenuSecondItemName() {
        return menuSecondItemName;
    }

    public void setMenuSecondItemName(String menuSecondItemName) {
        this.menuSecondItemName = menuSecondItemName;
    }

    public String getMenuThreeItemId() {
        return menuThreeItemId;
    }

    public void setMenuThreeItemId(String menuThreeItemId) {
        this.menuThreeItemId = menuThreeItemId;
    }

    public String getMenuThreeItemName() {
        return menuThreeItemName;
    }

    public void setMenuThreeItemName(String menuThreeItemName) {
        this.menuThreeItemName = menuThreeItemName;
    }

    public String getMenuItemId() {
        return menuItemId;
    }

    public void setMenuItemId(String menuItemId) {
        this.menuItemId = menuItemId;
    }

    public String getMenuItemName() {
        return menuItemName;
    }

    public void setMenuItemName(String menuItemName) {
        this.menuItemName = menuItemName;
    }
}
