package com.tcbj.website.model;

import javax.persistence.Table;
import tk.mybatis.mapper.annotation.NameStyle;
import tk.mybatis.mapper.code.Style;
import io.swagger.annotations.ApiModel;
import com.cyberway.msf.commons.model.base.BusinessEntityWithOrganization;
import javax.validation.constraints.NotNull;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import javax.persistence.Column;
import io.swagger.annotations.ApiModelProperty;

/** 文章类别 */
@Table(name = "website_category")
@NameStyle(Style.normal)
@ApiModel("文章类别")
public class Category extends BusinessEntityWithOrganization {

    /** 排序 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @Column(name = "category_sort")
    @ApiModelProperty("排序")
    private Integer categorySort;
    /** 描述 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("描述")
    private String description;
    /** 是否删除 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @Column(name = "is_delete")
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @Column(name = "is_en")
    @ApiModelProperty("是否英文")
    private Integer isEn;
    /** 名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("名称")
    private String name;

    /**
     * 设置 {@link #categorySort}
     *
     * @param categorySort {@link #categorySort}
     */
    public void setCategorySort(Integer categorySort) {
        this.categorySort = categorySort;
    }
    /**
     * 获取 {@link #categorySort}
     *
     * @return {@link #categorySort}
     */
    public Integer getCategorySort() {
        return categorySort;
    }
    /**
     * 设置 {@link #description}
     *
     * @param description {@link #description}
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 获取 {@link #description}
     *
     * @return {@link #description}
     */
    public String getDescription() {
        return description;
    }
    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #isEn}
     *
     * @param isEn {@link #isEn}
     */
    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }
    /**
     * 获取 {@link #isEn}
     *
     * @return {@link #isEn}
     */
    public Integer getIsEn() {
        return isEn;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
}
