package com.tcbj.website.model;

import javax.persistence.Table;
import tk.mybatis.mapper.annotation.NameStyle;
import tk.mybatis.mapper.code.Style;
import io.swagger.annotations.ApiModel;
import com.cyberway.msf.commons.model.base.BusinessEntityWithOrganization;
import javax.validation.constraints.NotNull;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import io.swagger.annotations.ApiModelProperty;

/** 创新研究 */
@Table(name = "website_innovation_english")
@NameStyle(Style.normal)
@ApiModel("创新研究")
public class InnovationEnglish extends BusinessEntityWithOrganization {

    /** 图片连接 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("图片连接")
    private String imgUrl;
    /** 机构介绍 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("机构介绍")
    private String introduce;
    /** 机构名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("机构名称")
    private String name;
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("是否移动端")
    private Integer type;

    /**
     * 设置 {@link #imgUrl}
     *
     * @param imgUrl {@link #imgUrl}
     */
    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }
    /**
     * 获取 {@link #imgUrl}
     *
     * @return {@link #imgUrl}
     */
    public String getImgUrl() {
        return imgUrl;
    }
    /**
     * 设置 {@link #introduce}
     *
     * @param introduce {@link #introduce}
     */
    public void setIntroduce(String introduce) {
        this.introduce = introduce;
    }
    /**
     * 获取 {@link #introduce}
     *
     * @return {@link #introduce}
     */
    public String getIntroduce() {
        return introduce;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
