package com.tcbj.website.model;

import com.cyberway.msf.commons.model.base.BusinessEntityWithOrganization;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import tk.mybatis.mapper.annotation.NameStyle;
import tk.mybatis.mapper.code.Style;

import javax.persistence.Table;

/** 知识库日志表 */
@Table(name = "website_knowledge_log")
@NameStyle(Style.normal)
@ApiModel("文章与标签关联表")
public class KnowledgeLog extends BusinessEntityWithOrganization {


    @ApiModelProperty("操作模块(文献,推荐书籍,指南共识,相关书籍,搜索)")
    private String operationModule;

    @ApiModelProperty("操作内容(查看详情,查看/下载pdf,文字搜索,标签搜索)")
    private String operationContext;

    @ApiModelProperty("具体内容")
    private String context;




    public String getOperationModule() {
        return operationModule;
    }

    public void setOperationModule(String operationModule) {
        this.operationModule = operationModule;
    }

    public String getOperationContext() {
        return operationContext;
    }

    public void setOperationContext(String operationContext) {
        this.operationContext = operationContext;
    }

    public String getContext() {
        return context;
    }

    public void setContext(String context) {
        this.context = context;
    }
}
