package com.tcbj.website.model;

import javax.persistence.Table;
import tk.mybatis.mapper.annotation.NameStyle;
import tk.mybatis.mapper.code.Style;
import io.swagger.annotations.ApiModel;
import com.cyberway.msf.commons.model.base.BusinessEntityWithOrganization;
import javax.persistence.Column;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;

/** 会员用户表 */
@Table(name = "website_member_user")
@NameStyle(Style.normal)
@ApiModel("会员用户表")
public class MemberUser extends BusinessEntityWithOrganization {
    /** 邮箱 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("邮箱")
    private String email;
    /** 是否删除 */
    @Column(name = "is_delete")
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 手机号码 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("手机号码")
    private Long mobile;
    /** 名称 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("名称")
    private String name;
    /** 密码 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("密码")
    private String password;
    /** 角色 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("角色：0-默认游客 1-会员 2-内部员工")
    private Integer role;
    /** 性别 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("性别：0-男 1-女")
    private Integer sex;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("登录：0-未登录 1-登录")
    protected Integer online;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("单位名称")
    private String unitName;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("职位名称")
    private String postName;

    @ApiModelProperty("esb平台账号")
    private String esbAccount;

    @ApiModelProperty("esb平台部门")
    private String esbDepartments;

    public String getEsbDepartments() {
        return esbDepartments;
    }

    public void setEsbDepartments(String esbDepartments) {
        this.esbDepartments = esbDepartments;
    }

    public String getEsbAccount() {
        return esbAccount;
    }

    public void setEsbAccount(String esbAccount) {
        this.esbAccount = esbAccount;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }

    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #mobile}
     *
     * @param mobile {@link #mobile}
     */
    public void setMobile(Long mobile) {
        this.mobile = mobile;
    }
    /**
     * 获取 {@link #mobile}
     *
     * @return {@link #mobile}
     */
    public Long getMobile() {
        return mobile;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
    /**
     * 设置 {@link #password}
     *
     * @param password {@link #password}
     */
    public void setPassword(String password) {
        this.password = password;
    }
    /**
     * 获取 {@link #password}
     *
     * @return {@link #password}
     */
    public String getPassword() {
        return password;
    }
    /**
     * 设置 {@link #role}
     *
     * @param role {@link #role}
     */
    public void setRole(Integer role) {
        this.role = role;
    }
    /**
     * 获取 {@link #role}
     *
     * @return {@link #role}
     */
    public Integer getRole() {
        return role;
    }
    /**
     * 设置 {@link #sex}
     *
     * @param sex {@link #sex}
     */
    public void setSex(Integer sex) {
        this.sex = sex;
    }
    /**
     * 获取 {@link #sex}
     *
     * @return {@link #sex}
     */
    public Integer getSex() {
        return sex;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getOnline() {
        return online;
    }

    public void setOnline(Integer online) {
        this.online = online;
    }
}
