package com.tcbj.website.vo;

import com.cyberway.msf.commons.model.base.vo.BaseSimpleVo;
import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/** 文章内容简单字段VO */
@ApiModel("文章内容简单字段VO")
public class ArticleContentSimpleForKnowledgeVo extends BaseSimpleVo {

    /** 附件 */
    @ApiModelProperty("附件")
    private List<AttachmentSimpleVo> attachment;
    /** 附件 */
    @ApiModelProperty("附件")
    private List<String> accessory;
    /** 文章类别 */
    @ApiModelProperty("文章类别ID")
    private String articleCategoryId;
    /** 文章类别 */
    @ApiModelProperty("文章类别名称")
    private String articleCategoryName;
    /** 文章标签 */
    @ApiModelProperty("文章标签")
    private  List<ArticleContentLabelSimpleForKnowledgeVo> articleLabel;

    @ApiModelProperty("文章所属栏目")
    private List<ArticleContentMenuFullVo> articleMenuList;
    /** 内容 */
    @ApiModelProperty("内容")
    private String content;
    /** 封面图片 */
    @ApiModelProperty("封面图片")
    private String coverPicture;
    /** 简介 */
    @ApiModelProperty("简介")
    private String description;
    /** 阅读量 */
    @ApiModelProperty("阅读量")
    private Integer hits;
    /** 是否删除 */
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文 */
    @ApiModelProperty("是否英文")
    private Integer isEn;
    /** 是否置顶 */
    @ApiModelProperty("是否置顶")
    private Integer isStick;
    /** 所属栏目 */
    @ApiModelProperty("所属栏目ID")
    private String menuItemId;
    /** 所属栏目 */
    @ApiModelProperty("所属栏目名称")
    private String menuItemName;
    /** 标题 */
    @ApiModelProperty("标题")
    private String name;
    /** 合作机构 */
    @ApiModelProperty("合作机构")
    private String operating;
    /** pdf文件 */
    @ApiModelProperty("pdf文件")
    private String pdf;
    /** 项目负责人 */
    @ApiModelProperty("项目负责人")
    private String projectLeader;
    /** 发布时间 */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @ApiModelProperty("发行时间")
    private Date releaseTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("上架时间")
    private Date shelfTime;
    /** 所属权限 */
    @ApiModelProperty("所属权限")
    private List<Integer> role;
    /** 状态 */
    @ApiModelProperty("状态：0-草稿 1-未发布 2-预约发布 3-已发布  4-取消发布")
    private Integer status;
    /** 标题图片 */
    @ApiModelProperty("标题图片")
    private String titlePicture;
    /** 视频 */
    @ApiModelProperty("视频")
    private String video;
    /** 地点 */
    @ApiModelProperty("地点")
    private String  site;
    /** 视频分组ID */
    @ApiModelProperty("视频分组ID")
    private String videoGroupId;

    /** 视频分组名称 */
    @ApiModelProperty("视频分组名称")
    private String videoGroupName;

    /** 一级栏目名称 */
    @ApiModelProperty("一级栏目名称")
    private String menuFirstItemName;
    /** 二级栏目名称 */
    @ApiModelProperty("二级栏目名称")
    private String menuSecondItemName;

    @ApiModelProperty("所属三级级栏目id")
    private String  menuThreeItemName;

    @ApiModelProperty("跳转连接")
    private String url;
    @ApiModelProperty("是否移动端显示")
    private Integer isPhone;

    /** 一级栏目ID */
    @ApiModelProperty("一级栏目ID")
    private String menuFirstItemId;
    /** 二级栏目ID */
    @ApiModelProperty("二级栏目ID")
    private String menuSecondItemId;

    @ApiModelProperty("所属三级级栏目ID")
    private String  menuThreeItemId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date lastModified;
    @ApiModelProperty("二维码地址")
    private String qrCode;
    @ApiModelProperty("视频banner图")
    private String bannerUrl;
    @ApiModelProperty("视频：是否展示首页")
    private Integer isHome;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文章类别一级标题(知识库专用字段)")
    private String articleCategoryFirstName;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文章类别二级标题(知识库专用字段)")
    private String articleCategorySecondName;

    @ApiModelProperty("出版社名称(知识库专用字段)")
    private String pressName;

    public String getPressName() {
        return pressName;
    }

    public void setPressName(String pressName) {
        this.pressName = pressName;
    }

    public List<ArticleContentMenuFullVo> getArticleMenuList() {
        return articleMenuList;
    }

    public void setArticleMenuList(List<ArticleContentMenuFullVo> articleMenuList) {
        this.articleMenuList = articleMenuList;
    }

    public String getArticleCategoryFirstName() {
        return articleCategoryFirstName;
    }

    public void setArticleCategoryFirstName(String articleCategoryFirstName) {
        this.articleCategoryFirstName = articleCategoryFirstName;
    }

    public String getArticleCategorySecondName() {
        return articleCategorySecondName;
    }

    public void setArticleCategorySecondName(String articleCategorySecondName) {
        this.articleCategorySecondName = articleCategorySecondName;
    }

    public Integer getIsHome() {
        return isHome;
    }

    public void setIsHome(Integer isHome) {
        this.isHome = isHome;
    }

    public String getBannerUrl() {
        return bannerUrl;
    }

    public void setBannerUrl(String bannerUrl) {
        this.bannerUrl = bannerUrl;
    }
    public String getQrCode() {
        return qrCode;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    @Override
    public Date getLastModified() {
        return lastModified;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }




    public List<AttachmentSimpleVo> getAttachment() {
        return attachment;
    }

    public void setAttachment(List<AttachmentSimpleVo> attachment) {
        this.attachment = attachment;
    }

    /**
     * 设置 {@link #accessory}
     *
     * @param accessory {@link #accessory}
     */
    public void setAccessory(List<String> accessory) {
        this.accessory = accessory;
    }
    /**
     * 获取 {@link #accessory}
     *
     * @return {@link #accessory}
     */
    public List<String> getAccessory() {
        return accessory;
    }

    public List<ArticleContentLabelSimpleForKnowledgeVo> getArticleLabel() {
        return articleLabel;
    }

    public void setArticleLabel(List<ArticleContentLabelSimpleForKnowledgeVo> articleLabel) {
        this.articleLabel = articleLabel;
    }

    /**
     * 设置 {@link #content}
     *
     * @param content {@link #content}
     */
    public void setContent(String content) {
        this.content = content;
    }
    /**
     * 获取 {@link #content}
     *
     * @return {@link #content}
     */
    public String getContent() {
        return content;
    }
    /**
     * 设置 {@link #coverPicture}
     *
     * @param coverPicture {@link #coverPicture}
     */
    public void setCoverPicture(String coverPicture) {
        this.coverPicture = coverPicture;
    }
    /**
     * 获取 {@link #coverPicture}
     *
     * @return {@link #coverPicture}
     */
    public String getCoverPicture() {
        return coverPicture;
    }
    /**
     * 设置 {@link #description}
     *
     * @param description {@link #description}
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 获取 {@link #description}
     *
     * @return {@link #description}
     */
    public String getDescription() {
        return description;
    }
    /**
     * 设置 {@link #hits}
     *
     * @param hits {@link #hits}
     */
    public void setHits(Integer hits) {
        this.hits = hits;
    }
    /**
     * 获取 {@link #hits}
     *
     * @return {@link #hits}
     */
    public Integer getHits() {
        return hits;
    }
    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #isEn}
     *
     * @param isEn {@link #isEn}
     */
    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }
    /**
     * 获取 {@link #isEn}
     *
     * @return {@link #isEn}
     */
    public Integer getIsEn() {
        return isEn;
    }
    /**
     * 设置 {@link #isStick}
     *
     * @param isStick {@link #isStick}
     */
    public void setIsStick(Integer isStick) {
        this.isStick = isStick;
    }
    /**
     * 获取 {@link #isStick}
     *
     * @return {@link #isStick}
     */
    public Integer getIsStick() {
        return isStick;
    }

    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
    /**
     * 设置 {@link #operating}
     *
     * @param operating {@link #operating}
     */
    public void setOperating(String operating) {
        this.operating = operating;
    }
    /**
     * 获取 {@link #operating}
     *
     * @return {@link #operating}
     */
    public String getOperating() {
        return operating;
    }
    /**
     * 设置 {@link #pdf}
     *
     * @param pdf {@link #pdf}
     */
    public void setPdf(String pdf) {
        this.pdf = pdf;
    }
    /**
     * 获取 {@link #pdf}
     *
     * @return {@link #pdf}
     */
    public String getPdf() {
        return pdf;
    }
    /**
     * 设置 {@link #projectLeader}
     *
     * @param projectLeader {@link #projectLeader}
     */
    public void setProjectLeader(String projectLeader) {
        this.projectLeader = projectLeader;
    }
    /**
     * 获取 {@link #projectLeader}
     *
     * @return {@link #projectLeader}
     */
    public String getProjectLeader() {
        return projectLeader;
    }
    /**
     * 设置 {@link #releaseTime}
     *
     * @param releaseTime {@link #releaseTime}
     */
    public void setReleaseTime(Date releaseTime) {
        this.releaseTime = releaseTime;
    }
    /**
     * 获取 {@link #releaseTime}
     *
     * @return {@link #releaseTime}
     */
    public Date getReleaseTime() {
        return releaseTime;
    }

    public Date getShelfTime() {
        return shelfTime;
    }

    public void setShelfTime(Date shelfTime) {
        this.shelfTime = shelfTime;
    }

    public List<Integer> getRole() {
        return role;
    }

    public void setRole(List<Integer> role) {
        this.role = role;
    }
    /** 设置 {@link #status}
     *
     * @param status {@link #status}
     */
    public void setStatus(Integer status) {
        this.status = status;
    }
    /**
     * 获取 {@link #status}
     *
     * @return {@link #status}
     */
    public Integer getStatus() {
        return status;
    }
    /**
     * 设置 {@link #titlePicture}
     *
     * @param titlePicture {@link #titlePicture}
     */
    public void setTitlePicture(String titlePicture) {
        this.titlePicture = titlePicture;
    }
    /**
     * 获取 {@link #titlePicture}
     *
     * @return {@link #titlePicture}
     */
    public String getTitlePicture() {
        return titlePicture;
    }
    /**
     * 设置 {@link #video}
     *
     * @param video {@link #video}
     */
    public void setVideo(String video) {
        this.video = video;
    }
    /**
     * 获取 {@link #video}
     *
     * @return {@link #video}
     */
    public String getVideo() {
        return video;
    }

    public String getArticleCategoryId() {
        return articleCategoryId;
    }

    public void setArticleCategoryId(String articleCategoryId) {
        this.articleCategoryId = articleCategoryId;
    }

    public String getArticleCategoryName() {
        return articleCategoryName;
    }

    public void setArticleCategoryName(String articleCategoryName) {
        this.articleCategoryName = articleCategoryName;
    }

    public String getMenuItemId() {
        return menuItemId;
    }

    public void setMenuItemId(String menuItemId) {
        this.menuItemId = menuItemId;
    }

    public String getMenuItemName() {
        return menuItemName;
    }

    public void setMenuItemName(String menuItemName) {
        this.menuItemName = menuItemName;
    }
    /**
     * 设置 {@link #site}
     *
     * @param site {@link #site}
     */
    public void setSite(String site) {
        this.site = site;
    }
    /**
     * 获取 {@link #site}
     *
     * @return {@link #site}
     */
    public String getSite() {
        return site;
    }

    public String getVideoGroupId() {
        return videoGroupId;
    }

    public void setVideoGroupId(String videoGroupId) {
        this.videoGroupId = videoGroupId;
    }

    public String getVideoGroupName() {
        return videoGroupName;
    }

    public void setVideoGroupName(String videoGroupName) {
        this.videoGroupName = videoGroupName;
    }

    public String getMenuFirstItemName() {
        return menuFirstItemName;
    }

    public void setMenuFirstItemName(String menuFirstItemName) {
        this.menuFirstItemName = menuFirstItemName;
    }

    public String getMenuSecondItemName() {
        return menuSecondItemName;
    }

    public void setMenuSecondItemName(String menuSecondItemName) {
        this.menuSecondItemName = menuSecondItemName;
    }

    public String getMenuThreeItemName() {
        return menuThreeItemName;
    }

    public void setMenuThreeItemName(String menuThreeItemName) {
        this.menuThreeItemName = menuThreeItemName;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getIsPhone() {
        return isPhone;
    }

    public void setIsPhone(Integer isPhone) {
        this.isPhone = isPhone;
    }

    public String getMenuFirstItemId() {
        return menuFirstItemId;
    }

    public void setMenuFirstItemId(String menuFirstItemId) {
        this.menuFirstItemId = menuFirstItemId;
    }

    public String getMenuSecondItemId() {
        return menuSecondItemId;
    }

    public void setMenuSecondItemId(String menuSecondItemId) {
        this.menuSecondItemId = menuSecondItemId;
    }

    public String getMenuThreeItemId() {
        return menuThreeItemId;
    }

    public void setMenuThreeItemId(String menuThreeItemId) {
        this.menuThreeItemId = menuThreeItemId;
    }
}
