package com.tcbj.website.vo;

import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import com.cyberway.msf.commons.model.base.vo.BaseFullVo;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;

/** 标签完整字段VO */
@ApiModel("标签完整字段VO")
public class LabelFullVo extends BaseFullVo {

    /** 描述 */
    @ApiModelProperty("描述")
    private String description;
    /** 是否删除 */
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文标签 */
    @ApiModelProperty("是否英文标签")
    private Integer isEn;

    /** 是否热门 */
    @ApiModelProperty("是否热门 0：否 1：是")
    private Integer isHot;

    /** 名称 */
    @ApiModelProperty("名称")
    private String name;


    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createdDate;

    /** 最后修改时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("最后修改时间")
    private Date lastModified;

    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("排序")
    private Integer sort;

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }


    /**
     * 设置 {@link #description}
     *
     * @param description {@link #description}
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 获取 {@link #description}
     *
     * @return {@link #description}
     */
    public String getDescription() {
        return description;
    }
    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #isEn}
     *
     * @param isEn {@link #isEn}
     */
    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }
    /**
     * 获取 {@link #isEn}
     *
     * @return {@link #isEn}
     */
    public Integer getIsEn() {
        return isEn;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }

    @Override
    public Date getCreatedDate() {
        return createdDate;
    }

    @Override
    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Integer getIsHot() {
        return isHot;
    }

    public void setIsHot(Integer isHot) {
        this.isHot = isHot;
    }

    @Override
    public Date getLastModified() {
        return lastModified;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }
}
