package com.tcbj.website.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import com.cyberway.msf.commons.model.base.vo.BaseFullVo;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/** 研究中心完整字段VO */
@ApiModel("研究中心完整字段VO")
public class ResearchCenterFullVo extends BaseFullVo {

    /** 内容 */
    @ApiModelProperty("内容")
    private String content;
    /** 中心名称 */
    @ApiModelProperty("中心名称")
    private String name;
    /** 排序 */
    @ApiModelProperty("排序")
    private Integer sort;
    /** 状态 */
    @ApiModelProperty("状态")
    private Integer status;
    /** 标题图片 */
    @ApiModelProperty("标题图片")
    private String titlePicture;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date lastModified;
    @ApiModelProperty("是否移动端")
    private Integer isPhone;

    public Integer getIsPhone() {
        return isPhone;
    }

    public void setIsPhone(Integer isPhone) {
        this.isPhone = isPhone;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public Date getLastModified() {
        return lastModified;
    }

    /**
     * 设置 {@link #content}
     *
     * @param content {@link #content}
     */
    public void setContent(String content) {
        this.content = content;
    }
    /**
     * 获取 {@link #content}
     *
     * @return {@link #content}
     */
    public String getContent() {
        return content;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
    /**
     * 设置 {@link #sort}
     *
     * @param sort {@link #sort}
     */
    public void setSort(Integer sort) {
        this.sort = sort;
    }
    /**
     * 获取 {@link #sort}
     *
     * @return {@link #sort}
     */
    public Integer getSort() {
        return sort;
    }
    /**
     * 设置 {@link #status}
     *
     * @param status {@link #status}
     */
    public void setStatus(Integer status) {
        this.status = status;
    }
    /**
     * 获取 {@link #status}
     *
     * @return {@link #status}
     */
    public Integer getStatus() {
        return status;
    }
    /**
     * 设置 {@link #titlePicture}
     *
     * @param titlePicture {@link #titlePicture}
     */
    public void setTitlePicture(String titlePicture) {
        this.titlePicture = titlePicture;
    }
    /**
     * 获取 {@link #titlePicture}
     *
     * @return {@link #titlePicture}
     */
    public String getTitlePicture() {
        return titlePicture;
    }
}
