package com.tcbj.website.vo;


import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import com.cyberway.msf.commons.model.base.vo.BaseSimpleVo;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/** 研究团队简单字段VO */
@ApiModel("研究团队简单字段VO")
public class ResearcherGroupSimpleVo extends BaseSimpleVo {

    /** 描述 */
    @ApiModelProperty("描述")
    private String description;
    /** 名称 */
    @ApiModelProperty("名称")
    private String name;
    /** 排序 */
    @ApiModelProperty("排序")
    private Integer sort;
    /** 是否首页展示 */
    @ApiModelProperty("是否首页展示")
    private Integer isHome;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date lastModified;

    @Override
    public Date getLastModified() {
        return lastModified;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Integer getIsHome() {
        return isHome;
    }

    public void setIsHome(Integer isHome) {
        this.isHome = isHome;
    }

    /**
     * 设置 {@link #description}
     *
     * @param description {@link #description}
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 获取 {@link #description}
     *
     * @return {@link #description}
     */
    public String getDescription() {
        return description;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
    /**
     * 设置 {@link #sort}
     *
     * @param sort {@link #sort}
     */
    public void setSort(Integer sort) {
        this.sort = sort;
    }
    /**
     * 获取 {@link #sort}
     *
     * @return {@link #sort}
     */
    public Integer getSort() {
        return sort;
    }
}
