package com.tcbj.website.vo;

import com.cyberway.msf.commons.model.valid.AllFieldSaveOrUpdate;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import com.cyberway.msf.commons.model.base.vo.BaseFullVo;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/** 视频组完整字段VO */
@ApiModel("视频组完整字段VO")
public class VideoGroupFullVo extends BaseFullVo {

    /** 描述 */
    @ApiModelProperty("描述")
    private String description;
    /** 是否删除 */
    @ApiModelProperty("是否删除")
    private Integer isDelete;
    /** 是否英文 */
    @ApiModelProperty("是否英文")
    private Integer isEn;
    /** 名称 */
    @ApiModelProperty("名称")
    private String name;
    /** 排序 */
    @ApiModelProperty("排序")
    private Integer sort;
    /** 发布时间 */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("发布时间")
    private Date releaseTime;
    /** 地点 */
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("地点")
    private String  site;
    @NotNull(groups = AllFieldSaveOrUpdate.class)
    @ApiModelProperty("文章列表")
    private List<ArticleContentSimpleVo> list;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date lastModified;

    @Override
    public Date getLastModified() {
        return lastModified;
    }

    @Override
    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    /**
     * 设置 {@link #description}
     *
     * @param description {@link #description}
     */
    public void setDescription(String description) {
        this.description = description;
    }
    /**
     * 获取 {@link #description}
     *
     * @return {@link #description}
     */
    public String getDescription() {
        return description;
    }
    /**
     * 设置 {@link #isDelete}
     *
     * @param isDelete {@link #isDelete}
     */
    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }
    /**
     * 获取 {@link #isDelete}
     *
     * @return {@link #isDelete}
     */
    public Integer getIsDelete() {
        return isDelete;
    }
    /**
     * 设置 {@link #isEn}
     *
     * @param isEn {@link #isEn}
     */
    public void setIsEn(Integer isEn) {
        this.isEn = isEn;
    }
    /**
     * 获取 {@link #isEn}
     *
     * @return {@link #isEn}
     */
    public Integer getIsEn() {
        return isEn;
    }
    /**
     * 设置 {@link #name}
     *
     * @param name {@link #name}
     */
    public void setName(String name) {
        this.name = name;
    }
    /**
     * 获取 {@link #name}
     *
     * @return {@link #name}
     */
    public String getName() {
        return name;
    }
    /**
     * 设置 {@link #sort}
     *
     * @param sort {@link #sort}
     */
    public void setSort(Integer sort) {
        this.sort = sort;
    }
    /**
     * 获取 {@link #sort}
     *
     * @return {@link #sort}
     */
    public Integer getSort() {
        return sort;
    }
    public Date getReleaseTime() {
        return releaseTime;
    }

    public void setReleaseTime(Date releaseTime) {
        this.releaseTime = releaseTime;
    }

    public String getSite() {
        return site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public List<ArticleContentSimpleVo> getList() {
        return list;
    }

    public void setList(List<ArticleContentSimpleVo> list) {
        this.list = list;
    }
}
