/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.hsf.consumer;

import com.alibaba.boot.hsf.HsfProperties;
import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.consumer.CallbackResolver;
import com.alibaba.boot.hsf.lightapi.AsyncMethod;
import com.alibaba.boot.hsf.utils.ConsumerPropertiesResolver;
import com.taobao.hsf.app.spring.util.HSFSpringConsumerBean;
import com.taobao.hsf.model.metadata.MethodSpecial;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

class HsfConsumerBeanDefinitionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HsfConsumerBeanDefinitionBuilder.class);
    private final Class<?> interfaceClass;
    private final HSFConsumer annotation;
    private HsfProperties properties;
    private BeanFactory beanFactory;
    private ApplicationContext context;

    HsfConsumerBeanDefinitionBuilder(Class<?> interfaceClass, HSFConsumer annotation) {
        this.interfaceClass = interfaceClass;
        this.annotation = annotation;
    }

    HsfConsumerBeanDefinitionBuilder properties(HsfProperties properties) {
        this.properties = properties != null ? properties : new HsfProperties();
        return this;
    }

    HsfConsumerBeanDefinitionBuilder context(ApplicationContext context) {
        this.context = context;
        return this;
    }

    HsfConsumerBeanDefinitionBuilder beanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        return this;
    }

    BeanDefinition build() {
        String ip;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HSFSpringConsumerBean.class);
        builder.setInitMethodName("init");
        builder.addPropertyValue("interfaceClass", this.interfaceClass);
        builder.addPropertyValue("group", (Object)ConsumerPropertiesResolver.resolveGroup(this.annotation, this.interfaceClass, this.properties, this.beanFactory));
        String version = ConsumerPropertiesResolver.resolveVersion(this.annotation, this.interfaceClass, this.properties, this.beanFactory);
        builder.addPropertyValue("version", (Object)version);
        Object clientTimeout = ConsumerPropertiesResolver.resolveTimeout(this.annotation, this.interfaceClass, this.properties, this.beanFactory);
        if (clientTimeout != null) {
            builder.addPropertyValue("clientTimeout", clientTimeout);
        }
        builder.addPropertyValue("maxWaitTimeForCsAddress", ConsumerPropertiesResolver.resolveMaxWaitTimeForCsAddress(this.annotation, this.interfaceClass, this.properties, this.beanFactory));
        builder.addPropertyValue("proxyStyle", (Object)this.annotation.proxyStyle());
        builder.addPropertyValue("generic", (Object)this.annotation.generic());
        String consistent = ConsumerPropertiesResolver.resolveConsistent(this.annotation, this.properties, this.beanFactory);
        if (!StringUtils.isEmpty((Object)consistent)) {
            builder.addPropertyValue("consistent", (Object)consistent);
        }
        if (!StringUtils.isEmpty((Object)(ip = ConsumerPropertiesResolver.resolveRoute(this.interfaceClass, this.properties, this.beanFactory)))) {
            if (StringUtils.isEmpty((Object)System.getProperty("hsf.run.mode"))) {
                System.getProperty("hsf.run.mode", "0");
            }
            builder.addPropertyValue("target", (Object)(ip + ":12200?v=2.0&_TIMEOUT=3000&ROUTE=-1&_IDLETIMEOUT=10&_p=hessian2&_SERIALIZETYPE=hessian"));
            logger.warn("HSF consumer {} is configured to connect to {}, which is not recommended in production environment", (Object)(this.interfaceClass.getName() + ":" + version), (Object)(ip + ":12200?v=2.0&_TIMEOUT=3000&ROUTE=-1&_IDLETIMEOUT=10&_p=hessian2&_SERIALIZETYPE=hessian"));
        }
        String[] futureMethods = this.annotation.futureMethods();
        Map<String, String> callbackMethods = CallbackResolver.processAsyncOnAnnotation(this.interfaceClass, this.context);
        ArrayList<AsyncMethod> asyncMethods = new ArrayList<AsyncMethod>();
        for (String method : futureMethods) {
            logger.debug("future method: {}", (Object)method);
            asyncMethods.add(new AsyncMethod(method));
        }
        for (String method : callbackMethods.keySet()) {
            logger.debug("async method: {}, callback listener: {}", (Object)method, (Object)callbackMethods.get(method));
            asyncMethods.add(new AsyncMethod(method, callbackMethods.get(method)));
        }
        this.processMethods(builder, asyncMethods);
        ArrayList<MethodSpecial> methodSpecials = new ArrayList<MethodSpecial>();
        HSFConsumer.ConsumerMethodSpecial[] hsfSpecialMethod = this.annotation.methodSpecials();
        if (hsfSpecialMethod != null && hsfSpecialMethod.length > 0) {
            for (HSFConsumer.ConsumerMethodSpecial consumerMethodSpecial : hsfSpecialMethod) {
                MethodSpecial methodSpecial = new MethodSpecial();
                methodSpecial.setMethodName(consumerMethodSpecial.methodName());
                if (StringUtils.hasText((String)consumerMethodSpecial.clientTimeout())) {
                    methodSpecial.setClientTimeout((long)Integer.parseInt(consumerMethodSpecial.clientTimeout()));
                }
                methodSpecial.setRetries(Integer.parseInt(consumerMethodSpecial.retries()));
                methodSpecials.add(methodSpecial);
            }
        }
        if (!methodSpecials.isEmpty()) {
            builder.addPropertyValue("methodSpecials", (Object)methodSpecials.toArray(new MethodSpecial[0]));
        }
        return builder.getBeanDefinition();
    }

    private void processMethods(BeanDefinitionBuilder builder, List<AsyncMethod> asyncMethods) {
        ArrayList<String> asyncMethodSignatures = new ArrayList<String>();
        for (AsyncMethod method : asyncMethods) {
            asyncMethodSignatures.add(method.signature());
        }
        builder.addPropertyValue("asyncallMethods", asyncMethodSignatures);
    }
}

