/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.hsf.consumer;

import com.alibaba.boot.hsf.HsfProperties;
import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.consumer.HsfConsumerBeanDefinitionBuilder;
import com.alibaba.boot.hsf.utils.HsfPropertiesUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class HsfConsumerPostProcessor
implements BeanClassLoaderAware,
EnvironmentAware,
BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(HsfConsumerPostProcessor.class);
    private ClassLoader classLoader;
    private ConfigurableEnvironment environment;
    private ApplicationContext context;
    private Map<String, BeanDefinition> beanDefinitions = new LinkedHashMap<String, BeanDefinition>();
    private ConfigurableListableBeanFactory beanFactory;

    HsfConsumerPostProcessor() {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.postProcessBeanFactory(beanFactory, (BeanDefinitionRegistry)beanFactory);
    }

    private void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry) {
        final HsfProperties properties = HsfPropertiesUtils.buildHsfProperties(this.environment);
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            String beanClassName = definition.getBeanClassName();
            if (beanClassName == null) continue;
            Class clazz = ClassUtils.resolveClassName((String)definition.getBeanClassName(), (ClassLoader)this.classLoader);
            ReflectionUtils.doWithFields((Class)clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    HsfConsumerPostProcessor.this.parseElement(field, properties);
                }
            });
        }
        for (String beanName : this.beanDefinitions.keySet()) {
            if (this.context.containsBean(beanName)) {
                throw new IllegalArgumentException("[HSF Starter] Spring context already has a bean named " + beanName + ", please change @HSFConsumer field name.");
            }
            registry.registerBeanDefinition(beanName, this.beanDefinitions.get(beanName));
            logger.info("registered HSFConsumerBean \"{}\" in spring context.", (Object)beanName);
        }
    }

    private void parseElement(Field field, HsfProperties properties) {
        HSFConsumer annotation = (HSFConsumer)AnnotationUtils.getAnnotation((AnnotatedElement)field, HSFConsumer.class);
        if (annotation == null) {
            return;
        }
        HsfConsumerBeanDefinitionBuilder beanDefinitionBuilder = new HsfConsumerBeanDefinitionBuilder(field.getType(), annotation);
        beanDefinitionBuilder.context(this.context).beanFactory((BeanFactory)this.beanFactory).properties(properties);
        BeanDefinition beanDefinition = beanDefinitionBuilder.build();
        this.beanDefinitions.put(field.getName(), beanDefinition);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }
}

