/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.hsf.endpoint;

import com.taobao.hsf.cluster.HeadRouter;
import com.taobao.hsf.model.metadata.ServiceMetadata;
import com.taobao.hsf.protocol.ServiceURL;
import com.taobao.hsf.registry.RegistryInvocationHandler;
import com.taobao.hsf.registry.RegistryProtocolInterceptor;
import java.util.ArrayList;
import java.util.List;

public class ConsumerInfo {
    private String writeMode;
    private String group;
    private String interfaceName;
    private int timeout;
    private String uniqueName;
    private String generic;
    private String version;
    private List<String> serviceAddresses;
    private long maxWaitTimeForCsAddress;

    public ConsumerInfo() {
    }

    public ConsumerInfo(ServiceMetadata serviceMetadata) {
        this.writeMode = serviceMetadata.getWriteMode();
        this.group = serviceMetadata.getGroup();
        this.interfaceName = serviceMetadata.getInterfaceName();
        this.timeout = serviceMetadata.getTimeout();
        this.uniqueName = serviceMetadata.getUniqueName();
        this.generic = serviceMetadata.getGeneric();
        this.version = serviceMetadata.getVersion();
        this.maxWaitTimeForCsAddress = serviceMetadata.getMaxWaitTimeForCsAddress();
        this.serviceAddresses = new ArrayList<String>();
        RegistryInvocationHandler registryInvocationHandler = (RegistryInvocationHandler)serviceMetadata.getAttachment((Object)RegistryProtocolInterceptor.REGISTRY_INVOCATION_HANDLER_KEY);
        if (registryInvocationHandler != null) {
            this.serviceAddresses = new ArrayList<String>();
            for (HeadRouter headRouter : registryInvocationHandler.getStrategies()) {
                List serviceURLs = headRouter.getServiceURLs();
                if (serviceURLs == null) continue;
                for (ServiceURL url : serviceURLs) {
                    this.serviceAddresses.add(url.getHost());
                }
            }
        }
    }

    public String getWriteMode() {
        return this.writeMode;
    }

    public void setWriteMode(String writeMode) {
        this.writeMode = writeMode;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public String getGeneric() {
        return this.generic;
    }

    public void setGeneric(String generic) {
        this.generic = generic;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<String> getServiceAddresses() {
        return this.serviceAddresses;
    }

    public void setServiceAddresses(List<String> serviceAddresses) {
        this.serviceAddresses = serviceAddresses;
    }

    public long getMaxWaitTimeForCsAddress() {
        return this.maxWaitTimeForCsAddress;
    }

    public void setMaxWaitTimeForCsAddress(long maxWaitTimeForCsAddress) {
        this.maxWaitTimeForCsAddress = maxWaitTimeForCsAddress;
    }
}

