/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.hsf.health;

import com.alibaba.boot.hsf.endpoint.ProviderInfo;
import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.model.ProviderServiceModel;
import java.util.Collection;
import java.util.LinkedList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.core.env.ConfigurableEnvironment;

public class HsfHealthIndicator
extends AbstractHealthIndicator {
    @Autowired
    ConfigurableEnvironment environment;

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        boolean ok = true;
        Collection allProvidedServices = ApplicationModel.instance().allProvidedServices();
        LinkedList<ProviderInfo> providers = new LinkedList<ProviderInfo>();
        for (ProviderServiceModel providerServiceModel : allProvidedServices) {
            if (!providerServiceModel.getMetadata().isReadyToPublish()) {
                ok = false;
            }
            providers.add(new ProviderInfo(providerServiceModel.getMetadata()));
        }
        if (ok) {
            builder.status(Status.UP);
        } else {
            builder.status(Status.OUT_OF_SERVICE);
        }
        builder.withDetail("providers", providers);
    }
}

