/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.hsf.lightapi;

import java.text.MessageFormat;

public class AsyncMethod {
    private AsyncType asyncType;
    private String methodName;
    private String callback;

    public AsyncMethod(String methodName) {
        this.methodName = methodName;
        this.asyncType = AsyncType.FUTURE;
    }

    public AsyncMethod(String methodName, String callback) {
        this.methodName = methodName;
        this.callback = callback;
        this.asyncType = callback != null ? AsyncType.CALLBACK : AsyncType.FUTURE;
    }

    public String signature() {
        if (this.asyncType == AsyncType.FUTURE) {
            return MessageFormat.format("name:{0};type:{1}", this.methodName, "future");
        }
        if (this.asyncType == AsyncType.CALLBACK) {
            return MessageFormat.format("name:{0};type:{1};listener:{2}", this.methodName, "callback", this.callback);
        }
        throw new IllegalStateException("async type should be either callback or future");
    }

    private static enum AsyncType {
        FUTURE,
        CALLBACK;

    }
}

