/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.hsf.lightapi;

import com.alibaba.boot.hsf.lightapi.AsyncMethod;
import com.taobao.hsf.app.api.util.HSFApiConsumerBean;
import com.taobao.hsf.model.metadata.MethodSpecial;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ConsumerService {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerService.class);
    private HSFApiConsumerBean consumer;
    private List<MethodSpecial> methodSpecials = new ArrayList<MethodSpecial>();
    private List<AsyncMethod> asyncMethods = new ArrayList<AsyncMethod>();
    private boolean consumed;
    private boolean shouldSync;

    ConsumerService() {
        this.consumer = new HSFApiConsumerBean();
    }

    public ConsumerService service(String service) {
        this.checkState();
        logger.debug("service: {}", (Object)service);
        this.consumer.setInterfaceName(service);
        return this;
    }

    public ConsumerService service(Class<?> service) {
        this.checkState();
        logger.debug("service: {}", (Object)service.getName());
        this.consumer.setInterfaceClass(service);
        return this;
    }

    public ConsumerService version(String version) {
        this.checkState();
        logger.debug("version: {}", (Object)version);
        this.consumer.setVersion(version);
        return this;
    }

    public ConsumerService group(String group) {
        this.checkState();
        logger.debug("group: {}", (Object)group);
        this.consumer.setGroup(group);
        return this;
    }

    public ConsumerService generic() {
        this.checkState();
        logger.debug("generic: true");
        this.consumer.setGeneric("true");
        return this;
    }

    public ConsumerService timeout(int timeout) {
        this.checkState();
        logger.debug("timeout: {}", (Object)timeout);
        this.consumer.setClientTimeout(timeout);
        return this;
    }

    public ConsumerService methodTimeout(String methodName, int timeout) {
        this.checkState();
        logger.debug("timeout for method {}: {}", (Object)methodName, (Object)timeout);
        MethodSpecial ms = new MethodSpecial();
        ms.setMethodName(methodName);
        ms.setClientTimeout((long)timeout);
        this.methodSpecials.add(ms);
        return this;
    }

    public ConsumerService addressWaitTime(int timeout) {
        this.checkState();
        logger.debug("wait time for syncing addresses: {}", (Object)timeout);
        this.consumer.setMaxWaitTimeForCsAddress(timeout);
        return this;
    }

    public ConsumerService proxyStyle(String proxyStyle) {
        this.checkState();
        logger.debug("proxy style: {}", (Object)proxyStyle);
        this.consumer.setProxyStyle(proxyStyle);
        return this;
    }

    public ConsumerService asyncMethod(String method) {
        this.checkState();
        logger.debug("future method: {}", (Object)method);
        this.asyncMethods.add(new AsyncMethod(method));
        return this;
    }

    public ConsumerService asyncMethod(String method, String callbackListener) {
        this.checkState();
        logger.debug("async method: {}, callback listener: {}", (Object)method, (Object)callbackListener);
        this.asyncMethods.add(new AsyncMethod(method, callbackListener));
        return this;
    }

    public ConsumerService targetIp(String ip) {
        this.checkState();
        if (ip != null && !ip.isEmpty()) {
            if (StringUtils.isEmpty((Object)System.getProperty("hsf.run.mode"))) {
                System.getProperty("hsf.run.mode", "0");
            }
            this.consumer.setTarget(ip + ":12200?v=2.0&_TIMEOUT=3000&ROUTE=-1&_IDLETIMEOUT=10&_p=hessian2&_SERIALIZETYPE=hessian");
            logger.warn("HSF consumer {} is configured to connect to {}, which is not recommended in production environment", (Object)this.uniqueName(), (Object)(ip + ":12200?v=2.0&_TIMEOUT=3000&ROUTE=-1&_IDLETIMEOUT=10&_p=hessian2&_SERIALIZETYPE=hessian"));
        }
        return this;
    }

    public ConsumerService sync() {
        this.checkState();
        logger.debug("sync service's addresses");
        this.shouldSync = true;
        return this;
    }

    public HSFApiConsumerBean build() {
        this.processMethods();
        return this.consumer;
    }

    public Object subscribe() {
        try {
            this.processMethods();
            this.consumer.init(this.shouldSync);
            this.consumed = true;
            logger.info("HSF consumer {} is ready", (Object)this.uniqueName());
            return this.consumer.getObject();
        }
        catch (Exception e) {
            throw new RuntimeException("fail to subscribe HSF service: " + this.uniqueName(), e);
        }
    }

    private String uniqueName() {
        return this.consumer.getMetadata().getInterfaceName() + ":" + this.consumer.getMetadata().getVersion();
    }

    private void processMethods() {
        ArrayList<String> asyncMethodSignatures = new ArrayList<String>();
        for (AsyncMethod method : this.asyncMethods) {
            asyncMethodSignatures.add(method.signature());
        }
        this.consumer.setAsyncallMethods(asyncMethodSignatures);
        this.consumer.setMethodSpecials(this.methodSpecials.toArray(new MethodSpecial[this.methodSpecials.size()]));
    }

    private void checkState() {
        if (this.consumed) {
            throw new IllegalStateException("cannot set more attributes since HSF consumer " + this.uniqueName() + " has already been built");
        }
    }
}

