/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.hsf.lightapi;

import com.taobao.hsf.app.api.util.HSFApiProviderBean;
import com.taobao.hsf.model.metadata.MethodSpecial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProviderService {
    private static final Logger logger = LoggerFactory.getLogger(ProviderService.class);
    private boolean published;
    private HSFApiProviderBean provider;
    private List<MethodSpecial> methodSpecials = new ArrayList<MethodSpecial>();

    ProviderService() {
        this.provider = new HSFApiProviderBean();
    }

    public ProviderService service(String service) {
        this.checkState();
        logger.debug("service: {}", (Object)service);
        this.provider.setServiceInterface(service);
        return this;
    }

    public ProviderService service(Class<?> service) {
        this.checkState();
        logger.debug("service: {}", (Object)service.getName());
        this.provider.setServiceInterfaceClass(service);
        return this;
    }

    public ProviderService name(String name) {
        this.checkState();
        logger.debug("name: {}", (Object)name);
        this.provider.setServiceName(name);
        return this;
    }

    public ProviderService version(String version) {
        this.checkState();
        logger.debug("version: {}", (Object)version);
        this.provider.setServiceVersion(version);
        return this;
    }

    public ProviderService group(String group) {
        this.checkState();
        logger.debug("group: {}", (Object)group);
        this.provider.setServiceGroup(group);
        return this;
    }

    public ProviderService impl(Object impl) {
        this.checkState();
        logger.debug("target: {}", impl);
        this.provider.setTarget(impl);
        return this;
    }

    public ProviderService timeout(int timeout) {
        this.checkState();
        logger.debug("timeout: {}", (Object)timeout);
        this.provider.setClientTimeout(timeout);
        return this;
    }

    public ProviderService corePoolSize(int corePoolSize) {
        this.checkState();
        if (corePoolSize > 0) {
            logger.debug("core pool size: {}", (Object)corePoolSize);
            this.provider.setCorePoolSize(Integer.toString(corePoolSize));
        }
        return this;
    }

    public ProviderService maxPoolSize(int maxPoolSize) {
        this.checkState();
        if (maxPoolSize > 0) {
            logger.debug("max pool size: {}", (Object)maxPoolSize);
            this.provider.setMaxPoolSize(Integer.toString(maxPoolSize));
        }
        return this;
    }

    public ProviderService methodTimeout(String methodName, int timeout) {
        this.checkState();
        logger.debug("config timeout {} for method {}", (Object)timeout, (Object)methodName);
        MethodSpecial ms = new MethodSpecial();
        ms.setMethodName(methodName);
        ms.setClientTimeout((long)timeout);
        this.methodSpecials.add(ms);
        return this;
    }

    public ProviderService writeMode(String writeMode, int route) {
        this.checkState();
        if ("unit".equals(writeMode) || "center".equals(writeMode)) {
            logger.debug("write mode: {}", (Object)writeMode);
            this.provider.setWriteMode(writeMode);
            if (writeMode.equals("unit")) {
                logger.debug("route: {}", (Object)route);
                this.provider.setRoute(route);
            }
        }
        return this;
    }

    public ProviderService clientTimeout(int clientTimeout) {
        this.checkState();
        logger.debug("client timeout: {}", (Object)clientTimeout);
        this.provider.setClientTimeout(clientTimeout);
        return this;
    }

    public ProviderService serializeType(String serializeType) {
        this.checkState();
        logger.debug("serialize type: {}", (Object)serializeType);
        if (serializeType.equals("java") || serializeType.equals("hessian")) {
            this.provider.setSerializeType(serializeType);
        }
        this.provider.setPreferSerializeType(serializeType);
        return this;
    }

    public ProviderService delayPublish(boolean delayed) {
        this.checkState();
        logger.debug("delay publish: {}", (Object)delayed);
        this.provider.setDelayedPublish(Boolean.toString(delayed));
        return this;
    }

    public ProviderService enableTXC(boolean enableTXC) {
        this.checkState();
        logger.debug("enableTXC: {}", (Object)enableTXC);
        this.provider.setEnableTXC(enableTXC);
        return this;
    }

    public ProviderService configServers(String ... configServers) {
        this.checkState();
        if (configServers != null && configServers.length > 0) {
            this.configServers(Arrays.asList(configServers));
        }
        return this;
    }

    public ProviderService configServers(List<String> configServers) {
        this.checkState();
        if (configServers != null && configServers.size() > 0) {
            this.provider.setConfigserverCenter(configServers);
            logger.debug("config servers: {}", configServers);
        }
        return this;
    }

    public HSFApiProviderBean build() {
        this.provider.setMethodSpecials(this.methodSpecials.toArray(new MethodSpecial[this.methodSpecials.size()]));
        return this.provider;
    }

    public void publish() {
        try {
            this.provider.setMethodSpecials(this.methodSpecials.toArray(new MethodSpecial[this.methodSpecials.size()]));
            this.provider.init();
            this.published = true;
            logger.info("HSF service {} published", (Object)this.uniqueName());
        }
        catch (Exception e) {
            throw new RuntimeException("failed to publish HSF service " + this.provider.getMetadata().getInterfaceName() + ":" + this.provider.getMetadata().getVersion(), e);
        }
    }

    public void offline() {
        if (this.published) {
            this.provider.unregister();
            logger.info("HSF service {} unregistered", (Object)this.uniqueName());
            this.published = false;
        }
    }

    public void online() {
        if (!this.published) {
            this.provider.register();
            logger.info("HSF service {} registered", (Object)this.uniqueName());
            this.published = true;
        }
    }

    boolean isPublished() {
        return this.published;
    }

    private String uniqueName() {
        return this.provider.getMetadata().getInterfaceName() + ":" + this.provider.getMetadata().getVersion();
    }

    private void checkState() {
        if (this.published) {
            throw new IllegalStateException("HSF provider has already been published");
        }
    }
}

