/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.hsf.provider;

import com.alibaba.boot.hsf.HsfProperties;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.boot.hsf.provider.StringListFactoryBean;
import com.alibaba.boot.hsf.utils.ProviderPropertiesResolver;
import com.taobao.hsf.app.spring.util.HSFSpringProviderBean;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class HsfProviderBeanDefinitionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HsfProviderBeanDefinitionBuilder.class);
    private static AtomicInteger configCenterParseHelperCounter = new AtomicInteger(0);
    private final String targetRef;
    private final HSFProvider annotation;
    private Class<?> clazz;
    private HsfProperties properties;

    HsfProviderBeanDefinitionBuilder(String targetRef, HSFProvider annotation) {
        this.targetRef = targetRef;
        this.annotation = annotation;
    }

    HsfProviderBeanDefinitionBuilder properties(HsfProperties properties) {
        this.properties = properties != null ? properties : new HsfProperties();
        return this;
    }

    HsfProviderBeanDefinitionBuilder clazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    BeanDefinition build(BeanDefinitionRegistry registry) {
        String supportAsynCall;
        String serializeType;
        String invokeType;
        String serviceInterface = null;
        if (this.annotation.serviceInterface().equals(Object.class)) {
            Class[] allInterfaces = ClassUtils.getAllInterfacesForClass(this.clazz);
            if (allInterfaces == null || allInterfaces.length != 1) throw new IllegalArgumentException("@HSFProvider class: " + this.clazz.getName() + " implements more than one interface: " + allInterfaces);
            serviceInterface = allInterfaces[0].getName();
        } else {
            serviceInterface = this.annotation.serviceInterface().getName();
        }
        if ("false".equalsIgnoreCase(this.properties.getEnables().get(serviceInterface))) {
            logger.warn("HSF service {} is disabled, therefore will not publish.", (Object)serviceInterface);
            return null;
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HSFSpringProviderBean.class);
        builder.setInitMethodName("init");
        builder.addPropertyValue("serviceInterface", (Object)serviceInterface);
        builder.addPropertyValue("serviceVersion", (Object)ProviderPropertiesResolver.resolveVersion(this.annotation, serviceInterface, this.properties));
        builder.addPropertyValue("serviceGroup", (Object)ProviderPropertiesResolver.resolveGroup(this.annotation, serviceInterface, this.properties));
        builder.addPropertyValue("serviceName", (Object)this.annotation.serviceName());
        Object clientTimeout = ProviderPropertiesResolver.resolveTimeout(this.annotation, serviceInterface, this.properties);
        if (clientTimeout != null) {
            builder.addPropertyValue("clientTimeout", clientTimeout);
        }
        builder.addPropertyValue("writeMode", StringUtils.hasText((String)this.annotation.writeMode()) ? this.annotation.writeMode() : null);
        builder.addPropertyValue("route", (Object)this.annotation.route());
        builder.addPropertyValue("corePoolSize", ProviderPropertiesResolver.resolveCorePoolSize(this.annotation, serviceInterface, this.properties));
        builder.addPropertyValue("maxPoolSize", ProviderPropertiesResolver.resolveMaxPoolSize(this.annotation, serviceInterface, this.properties));
        builder.addPropertyValue("delayedPublish", ProviderPropertiesResolver.resolveDelayPublish(this.annotation, serviceInterface, this.properties));
        String configserverCenter = ProviderPropertiesResolver.resolveConfigserverCenter(this.annotation, serviceInterface, this.properties);
        if (!StringUtils.isEmpty((Object)configserverCenter)) {
            builder.addPropertyReference("configserverCenter", this.createConfigServerCenterParseHelper(registry, configserverCenter));
        }
        if (!StringUtils.isEmpty((Object)(invokeType = ProviderPropertiesResolver.resolveInvokeType(this.annotation, serviceInterface, this.properties)))) {
            builder.addPropertyValue("invokeType", (Object)invokeType);
        }
        if (!StringUtils.isEmpty((Object)(serializeType = ProviderPropertiesResolver.resolveSerializeType(this.annotation, serviceInterface, this.properties)))) {
            builder.addPropertyValue("serializeType", (Object)serializeType);
        }
        if (!StringUtils.isEmpty((Object)(supportAsynCall = ProviderPropertiesResolver.resolveSupportAsynCall(this.annotation, serviceInterface, this.properties)))) {
            builder.addPropertyValue("supportAsynCall", (Object)supportAsynCall);
        }
        builder.addPropertyReference("target", this.targetRef);
        if (this.annotation.includeFilters() != null && this.annotation.includeFilters().length > 0) {
            builder.addPropertyValue("includeFilters", Arrays.asList(this.annotation.includeFilters()));
        }
        builder.addPropertyValue("enableTXC", (Object)this.annotation.enableTXC());
        return builder.getBeanDefinition();
    }

    private String createConfigServerCenterParseHelper(BeanDefinitionRegistry registry, String configserverCenter) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StringListFactoryBean.class);
        builder.addPropertyValue("listString", (Object)configserverCenter);
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        String beanName = "configServerConterParseHelper" + configCenterParseHelperCounter.incrementAndGet();
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        return beanName;
    }
}

