/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.hsf.utils;

import com.alibaba.boot.hsf.HsfProperties;
import com.alibaba.boot.hsf.annotation.HSFConsumer;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.util.StringUtils;

public class ConsumerPropertiesResolver {
    public static String resolveGroup(HSFConsumer annotation, Class<?> interfaceClass, HsfProperties properties, BeanFactory factory) {
        String group = ConsumerPropertiesResolver.isDefaultGroup(annotation.serviceGroup()) ? properties.getGroup() : annotation.serviceGroup();
        String specific = ConsumerPropertiesResolver.findValue(interfaceClass.getName(), properties.getGroups());
        return ConsumerPropertiesResolver.isEmpty(specific) ? ConsumerPropertiesResolver.resolve(factory, group) : ConsumerPropertiesResolver.resolve(factory, specific);
    }

    public static String resolveVersion(HSFConsumer annotation, Class<?> interfaceClass, HsfProperties properties, BeanFactory factory) {
        String version = ConsumerPropertiesResolver.isDefaultVersion(annotation.serviceVersion()) ? properties.getVersion() : annotation.serviceVersion();
        String specific = ConsumerPropertiesResolver.findValue(interfaceClass.getName(), properties.getVersions());
        return ConsumerPropertiesResolver.isEmpty(specific) ? ConsumerPropertiesResolver.resolve(factory, version) : ConsumerPropertiesResolver.resolve(factory, specific);
    }

    public static Object resolveTimeout(HSFConsumer annotation, Class<?> interfaceClass, HsfProperties properties, BeanFactory factory) {
        String timeoutString;
        int timeout = annotation.clientTimeout();
        if (timeout < 0 && properties.getTimeout() != null) {
            timeout = properties.getTimeout();
        }
        if (ConsumerPropertiesResolver.isEmpty(timeoutString = ConsumerPropertiesResolver.findValue(interfaceClass.getName(), properties.getTimeouts()))) {
            timeoutString = annotation.clientTimeoutStr();
        }
        if (StringUtils.hasText((String)timeoutString)) {
            return ConsumerPropertiesResolver.resolve(factory, timeoutString);
        }
        if (timeout > 0) {
            return timeout;
        }
        return null;
    }

    public static Object resolveMaxWaitTimeForCsAddress(HSFConsumer annotation, Class<?> interfaceClass, HsfProperties properties, BeanFactory factory) {
        int maxWaitTimeForCsAddress = ConsumerPropertiesResolver.isDefaultMaxWaitTimeForCsAddress(annotation.addressWaitTime()) ? properties.getMaxWaitAddressTime().intValue() : annotation.addressWaitTime();
        String maxWaitAddressTimeString = ConsumerPropertiesResolver.findValue(interfaceClass.getName(), properties.getMaxWaitAddressTimes());
        if (ConsumerPropertiesResolver.isEmpty(maxWaitAddressTimeString)) {
            maxWaitAddressTimeString = annotation.addressWaitTimeStr();
        }
        return ConsumerPropertiesResolver.isEmpty(maxWaitAddressTimeString) ? maxWaitTimeForCsAddress : Integer.parseInt(ConsumerPropertiesResolver.resolve(factory, maxWaitAddressTimeString));
    }

    public static String resolveRoute(Class<?> interfaceClass, HsfProperties properties, BeanFactory factory) {
        String route = ConsumerPropertiesResolver.findValue(interfaceClass.getName(), properties.getRoutes());
        return ConsumerPropertiesResolver.resolve(factory, route);
    }

    public static String resolveConsistent(HSFConsumer annotation, HsfProperties properties, BeanFactory factory) {
        if (StringUtils.isEmpty((Object)annotation.consistent())) {
            return annotation.consistent();
        }
        return ConsumerPropertiesResolver.resolve(factory, annotation.consistent());
    }

    private static String findValue(String interfaceName, Map<String, String> values) {
        if (values != null && values.containsKey(interfaceName)) {
            return values.get(interfaceName);
        }
        return null;
    }

    private static boolean isDefaultGroup(String group) {
        return "HSF".equals(group);
    }

    private static boolean isDefaultVersion(String version) {
        return "1.0.0.DAILY".equals(version);
    }

    private static boolean isDefaultMaxWaitTimeForCsAddress(int maxWaitTimeForCsAddress) {
        return maxWaitTimeForCsAddress == 3000;
    }

    private static String resolve(BeanFactory beanFactory, String value) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)beanFactory).resolveEmbeddedValue(value);
        }
        return value;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

